/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class AnchorPointOverlay
implements class_4068,
class_364 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final LayoutEditorScreen editor;
    protected AnchorPointArea lastTickHoveredArea = null;
    protected AnchorPointArea currentlyHoveredArea = null;
    protected AnchorPointArea lastCompletedHoverArea = null;
    protected boolean lastTickDraggedEmpty = true;
    protected long areaHoverStartTime = -1L;
    protected boolean overlayVisibilityKeybindPressed = false;
    protected AnchorPointArea topLeftArea = new AnchorPointArea(ElementAnchorPoints.TOP_LEFT, 30, 30, AnchorPointArea.ProgressDirection.TO_RIGHT);
    protected AnchorPointArea midLeftArea = new AnchorPointArea(ElementAnchorPoints.MID_LEFT, 30, 30, AnchorPointArea.ProgressDirection.TO_RIGHT);
    protected AnchorPointArea bottomLeftArea = new AnchorPointArea(ElementAnchorPoints.BOTTOM_LEFT, 30, 30, AnchorPointArea.ProgressDirection.TO_RIGHT);
    protected AnchorPointArea topCenteredArea = new AnchorPointArea(ElementAnchorPoints.TOP_CENTERED, 30, 30, AnchorPointArea.ProgressDirection.TO_DOWN);
    protected AnchorPointArea midCenteredArea = new AnchorPointArea(ElementAnchorPoints.MID_CENTERED, 30, 30, AnchorPointArea.ProgressDirection.TO_TOP);
    protected AnchorPointArea bottomCenteredArea = new AnchorPointArea(ElementAnchorPoints.BOTTOM_CENTERED, 30, 30, AnchorPointArea.ProgressDirection.TO_TOP);
    protected AnchorPointArea topRightArea = new AnchorPointArea(ElementAnchorPoints.TOP_RIGHT, 30, 30, AnchorPointArea.ProgressDirection.TO_LEFT);
    protected AnchorPointArea midRightArea = new AnchorPointArea(ElementAnchorPoints.MID_RIGHT, 30, 30, AnchorPointArea.ProgressDirection.TO_LEFT);
    protected AnchorPointArea bottomRightArea = new AnchorPointArea(ElementAnchorPoints.BOTTOM_RIGHT, 30, 30, AnchorPointArea.ProgressDirection.TO_LEFT);
    protected AnchorPointArea[] anchorPointAreas = new AnchorPointArea[]{this.topLeftArea, this.midLeftArea, this.bottomLeftArea, this.topCenteredArea, this.midCenteredArea, this.bottomCenteredArea, this.topRightArea, this.midRightArea, this.bottomRightArea};

    public AnchorPointOverlay(@NotNull LayoutEditorScreen editor) {
        this.editor = Objects.requireNonNull(editor);
    }

    public void resetAreaHoverCache() {
        this.currentlyHoveredArea = null;
        this.lastTickHoveredArea = null;
        this.areaHoverStartTime = -1L;
    }

    public void resetOverlay() {
        this.resetAreaHoverCache();
        this.setLastCompletedHoverArea(null);
        this.lastTickDraggedEmpty = true;
        this.overlayVisibilityKeybindPressed = false;
    }

    public double getOverlayHoverChargingTimeSeconds() {
        return FancyMenu.getOptions().anchorOverlayHoverChargingTimeSeconds.getValue();
    }

    public long getOverlayHoverChargingTimeMs() {
        return (long)(this.getOverlayHoverChargingTimeSeconds() * 1000.0);
    }

    @NotNull
    public AnchorOverlayVisibilityMode getVisibilityMode() {
        AnchorOverlayVisibilityMode m = AnchorOverlayVisibilityMode.getByName(FancyMenu.getOptions().anchorOverlayVisibilityMode.getValue());
        return m != null ? m : AnchorOverlayVisibilityMode.DRAGGING;
    }

    public boolean isOverlayVisible() {
        if (this.getVisibilityMode() == AnchorOverlayVisibilityMode.DISABLED) {
            return false;
        }
        if (this.getVisibilityMode() == AnchorOverlayVisibilityMode.DRAGGING) {
            return !this.editor.getCurrentlyDraggedElements().isEmpty();
        }
        if (this.getVisibilityMode() == AnchorOverlayVisibilityMode.KEYBIND) {
            return this.overlayVisibilityKeybindPressed;
        }
        return true;
    }

    public boolean invertOverlayColors() {
        return FancyMenu.getOptions().invertAnchorOverlayColor.getValue();
    }

    @Nullable
    public DrawableColor getOverlayColorBaseOverride() {
        String override = FancyMenu.getOptions().anchorOverlayColorBaseOverride.getValue();
        if (override.trim().isEmpty()) {
            return null;
        }
        if (!TextValidators.HEX_COLOR_TEXT_VALIDATOR.get(override).booleanValue()) {
            return null;
        }
        return DrawableColor.of(override);
    }

    @Nullable
    public DrawableColor getOverlayColorBorderOverride() {
        String override = FancyMenu.getOptions().anchorOverlayColorBorderOverride.getValue();
        if (override.trim().isEmpty()) {
            return null;
        }
        if (!TextValidators.HEX_COLOR_TEXT_VALIDATOR.get(override).booleanValue()) {
            return null;
        }
        return DrawableColor.of(override);
    }

    @NotNull
    public DrawableColor getOverlayColorBase() {
        if (this.invertOverlayColors()) {
            return DrawableColor.WHITE;
        }
        DrawableColor override = this.getOverlayColorBaseOverride();
        return override != null ? override : UIBase.getUIColorTheme().layout_editor_anchor_point_overlay_color_base;
    }

    @NotNull
    public DrawableColor getOverlayColorBorder() {
        if (this.invertOverlayColors()) {
            return DrawableColor.WHITE;
        }
        DrawableColor override = this.getOverlayColorBorderOverride();
        return override != null ? override : UIBase.getUIColorTheme().layout_editor_anchor_point_overlay_color_border;
    }

    public boolean isOverlayBusy() {
        return !this.editor.getCurrentlyDraggedElements().isEmpty();
    }

    public float getOverlayOpacityNormal() {
        return FancyMenu.getOptions().anchorOverlayOpacityPercentageNormal.getValue().floatValue();
    }

    public float getOverlayOpacityBusy() {
        return FancyMenu.getOptions().anchorOverlayOpacityPercentageBusy.getValue().floatValue();
    }

    public int getOverlayOpacity() {
        float percentage;
        if (this.invertOverlayColors()) {
            return 255;
        }
        float f = percentage = this.isOverlayBusy() ? this.getOverlayOpacityBusy() : this.getOverlayOpacityNormal();
        if (percentage > 1.0f) {
            percentage = 1.0f;
        }
        if (percentage < 0.0f) {
            percentage = 0.0f;
        }
        return Math.min(255, Math.max(0, (int)(percentage * 255.0f)));
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.isOverlayVisible()) {
            this.resetOverlay();
            return;
        }
        this.tickAreaMouseOver(mouseX, mouseY);
        RenderingUtils.resetShaderColor(graphics);
        RenderSystem.enableBlend();
        if (this.invertOverlayColors()) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        this.renderAreas(graphics, mouseX, mouseY, partial);
        this.renderConnectionLines(graphics);
        RenderSystem.defaultBlendFunc();
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void renderAreas(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        int menuBarHeight;
        int n = menuBarHeight = this.editor.menuBar != null ? (int)((float)this.editor.menuBar.getHeight() * UIBase.calculateFixedScale(this.editor.menuBar.getScale())) : 0;
        if (this.editor.menuBar != null && !this.editor.menuBar.isExpanded()) {
            menuBarHeight = 0;
        }
        this.topLeftArea.x = -1;
        this.topLeftArea.y = -1 + menuBarHeight;
        this.topLeftArea.method_25394(graphics, mouseX, mouseY, partial);
        this.midLeftArea.x = -1;
        this.midLeftArea.y = ScreenUtils.getScreenHeight() / 2 - this.midLeftArea.getHeight() / 2;
        this.midLeftArea.method_25394(graphics, mouseX, mouseY, partial);
        this.bottomLeftArea.x = -1;
        this.bottomLeftArea.y = ScreenUtils.getScreenHeight() - this.bottomLeftArea.getHeight() + 1;
        this.bottomLeftArea.method_25394(graphics, mouseX, mouseY, partial);
        this.topCenteredArea.x = ScreenUtils.getScreenWidth() / 2 - this.topCenteredArea.getWidth() / 2;
        this.topCenteredArea.y = -1 + menuBarHeight;
        this.topCenteredArea.method_25394(graphics, mouseX, mouseY, partial);
        this.midCenteredArea.x = ScreenUtils.getScreenWidth() / 2 - this.midCenteredArea.getWidth() / 2;
        this.midCenteredArea.y = ScreenUtils.getScreenHeight() / 2 - this.midCenteredArea.getHeight() / 2;
        this.midCenteredArea.method_25394(graphics, mouseX, mouseY, partial);
        this.bottomCenteredArea.x = ScreenUtils.getScreenWidth() / 2 - this.bottomCenteredArea.getWidth() / 2;
        this.bottomCenteredArea.y = ScreenUtils.getScreenHeight() - this.bottomCenteredArea.getHeight() + 1;
        this.bottomCenteredArea.method_25394(graphics, mouseX, mouseY, partial);
        this.topRightArea.x = ScreenUtils.getScreenWidth() - this.topRightArea.getWidth() + 1;
        this.topRightArea.y = -1 + menuBarHeight;
        this.topRightArea.method_25394(graphics, mouseX, mouseY, partial);
        this.midRightArea.x = ScreenUtils.getScreenWidth() - this.midRightArea.getWidth() + 1;
        this.midRightArea.y = ScreenUtils.getScreenHeight() / 2 - this.midRightArea.getHeight() / 2;
        this.midRightArea.method_25394(graphics, mouseX, mouseY, partial);
        this.bottomRightArea.x = ScreenUtils.getScreenWidth() - this.bottomRightArea.getWidth() + 1;
        this.bottomRightArea.y = ScreenUtils.getScreenHeight() - this.bottomRightArea.getHeight() + 1;
        this.bottomRightArea.method_25394(graphics, mouseX, mouseY, partial);
        if (this.currentlyHoveredArea != null) {
            this.currentlyHoveredArea.renderMouseOverProgress(graphics, this.calculateMouseOverProgress());
        }
    }

    protected float calculateMouseOverProgress() {
        if (this.currentlyHoveredArea != null) {
            long now = System.currentTimeMillis();
            if (this.areaHoverStartTime + this.getOverlayHoverChargingTimeMs() > now) {
                long diff = this.areaHoverStartTime + this.getOverlayHoverChargingTimeMs() - now;
                float f = Math.max(0.0f, Math.min(1.0f, Math.max(1.0f, (float)diff) / (float)this.getOverlayHoverChargingTimeMs()));
                return 1.0f - f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    protected void renderConnectionLines(@NotNull class_332 graphics) {
        List<AbstractEditorElement> elements = FancyMenu.getOptions().showAllAnchorOverlayConnections.getValue() != false ? this.editor.getAllElements() : this.editor.getCurrentlyDraggedElements();
        for (AbstractEditorElement e : elements) {
            HideableElement h;
            boolean hidden = e instanceof HideableElement && (h = (HideableElement)((Object)e)).isHidden();
            if (hidden) continue;
            this.renderConnectionLineFor(graphics, e);
        }
    }

    protected void renderConnectionLineFor(@NotNull class_332 graphics, @NotNull AbstractEditorElement e) {
        AnchorPointArea a = this.getParentAreaOfElement(e);
        if (a != null) {
            int xElement = e.getX() + e.getWidth() / 2;
            int yElement = e.getY() + e.getHeight() / 2;
            int xArea = a.getX() + a.getWidth() / 2;
            int yArea = a.getY() + a.getHeight() / 2;
            this.renderSquareLine(graphics, xElement, yElement, xArea, yArea, 2, RenderingUtils.replaceAlphaInColor(this.getOverlayColorBase().getColorInt(), this.getOverlayOpacity()));
        }
    }

    protected void renderSquareLine(@NotNull class_332 graphics, int xElement, int yElement, int xArea, int yArea, int lineThickness, int color) {
        int horizontalWidth = Math.max(xElement, xArea) - Math.min(xElement, xArea);
        int verticalHeight = Math.max(yElement, yArea) - Math.min(yElement, yArea);
        int horizontalX = Math.min(xElement, xArea);
        int horizontalY = yArea;
        int verticalX = xElement;
        int verticalY = Math.min(yElement, yArea);
        if (xArea < xElement) {
            horizontalX += lineThickness;
        }
        RenderSystem.enableBlend();
        UIBase.resetShaderColor(graphics);
        graphics.method_25294(horizontalX, horizontalY, horizontalX + horizontalWidth, horizontalY + lineThickness, color);
        graphics.method_25294(verticalX, verticalY, verticalX + lineThickness, verticalY + verticalHeight, color);
        UIBase.resetShaderColor(graphics);
    }

    protected void tickAreaMouseOver(int mouseX, int mouseY) {
        boolean draggedEmpty = this.editor.getCurrentlyDraggedElements().isEmpty();
        if (!draggedEmpty) {
            AnchorPointArea anchorPointArea = this.currentlyHoveredArea = FancyMenu.getOptions().anchorOverlayChangeAnchorOnAreaHover.getValue() != false ? this.getMouseOverArea(mouseX, mouseY) : null;
            if (this.lastTickDraggedEmpty) {
                this.setLastCompletedHoverArea(this.currentlyHoveredArea);
            }
            if (this.currentlyHoveredArea == null) {
                this.setLastCompletedHoverArea(null);
            }
            if (this.isSameArea(this.currentlyHoveredArea, this.lastCompletedHoverArea)) {
                this.currentlyHoveredArea = null;
            }
            if (this.currentlyHoveredArea != null && !this.isSameArea(this.currentlyHoveredArea, this.lastTickHoveredArea)) {
                this.areaHoverStartTime = System.currentTimeMillis();
            }
            this.lastTickHoveredArea = this.currentlyHoveredArea;
            if (this.currentlyHoveredArea != null && this.areaHoverStartTime + this.getOverlayHoverChargingTimeMs() <= System.currentTimeMillis()) {
                for (AbstractEditorElement e : this.editor.getCurrentlyDraggedElements()) {
                    if (!this.canChangeAnchorTo(e, this.currentlyHoveredArea)) continue;
                    e.setAnchorPointViaOverlay(this.currentlyHoveredArea, mouseX, mouseY);
                }
                this.setLastCompletedHoverArea(this.currentlyHoveredArea);
                this.resetAreaHoverCache();
            }
        } else {
            this.resetAreaHoverCache();
        }
        this.lastTickDraggedEmpty = draggedEmpty;
    }

    protected boolean isSameArea(@Nullable AnchorPointArea firstArea, @Nullable AnchorPointArea secondArea) {
        if (firstArea == null && secondArea == null) {
            return true;
        }
        if (firstArea == null || secondArea == null) {
            return false;
        }
        if (firstArea instanceof ElementAnchorPointArea) {
            ElementAnchorPointArea a1 = (ElementAnchorPointArea)firstArea;
            if (secondArea instanceof ElementAnchorPointArea) {
                ElementAnchorPointArea a2 = (ElementAnchorPointArea)secondArea;
                return StringUtils.equals((CharSequence)a1.elementIdentifier, (CharSequence)a2.elementIdentifier);
            }
        }
        return firstArea.anchorPoint == secondArea.anchorPoint;
    }

    protected boolean canChangeAnchorTo(@NotNull AbstractEditorElement element, @NotNull AnchorPointArea area) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(area);
        if (this.isAttachedToAnchor(element, area)) {
            return false;
        }
        if (area instanceof ElementAnchorPointArea) {
            AbstractElement parentOfAreaElement;
            AbstractEditorElement areaElement = this.editor.getElementByInstanceIdentifier(((ElementAnchorPointArea)area).elementIdentifier);
            AbstractElement abstractElement = parentOfAreaElement = areaElement != null ? areaElement.element.getElementAnchorPointParent() : null;
            if (parentOfAreaElement != null && parentOfAreaElement.getInstanceIdentifier().equals(element.element.getInstanceIdentifier())) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected List<AbstractEditorElement> getChildElementsOfDraggedElements() {
        List<AbstractEditorElement> currentlyDragged = this.editor.getCurrentlyDraggedElements();
        ArrayList<AbstractEditorElement> children = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : currentlyDragged) {
            List<AbstractEditorElement> childChainOfE = this.editor.getElementChildChainOfExcluding(e);
            if (childChainOfE == null) {
                return null;
            }
            childChainOfE.forEach(element -> {
                if (!currentlyDragged.contains(element)) {
                    children.add((AbstractEditorElement)element);
                }
            });
        }
        return children;
    }

    protected boolean isAttachedToAnchor(@NotNull AbstractEditorElement element, @NotNull AnchorPointArea area) {
        if (area instanceof ElementAnchorPointArea) {
            ElementAnchorPointArea ae = (ElementAnchorPointArea)area;
            String parentOfElement = element.element.getAnchorPointElementIdentifier();
            if (parentOfElement != null) {
                return ae.elementIdentifier.equals(parentOfElement);
            }
        }
        return element.element.anchorPoint == area.anchorPoint;
    }

    @Nullable
    protected AnchorPointArea getParentAreaOfElement(@NotNull AbstractEditorElement element) {
        if (element.element.anchorPoint == ElementAnchorPoints.ELEMENT) {
            AbstractEditorElement e;
            if (element.element.getAnchorPointElementIdentifier() != null && (e = this.editor.getElementByInstanceIdentifier(element.element.getAnchorPointElementIdentifier())) != null) {
                return new ElementAnchorPointArea(e.element.getInstanceIdentifier());
            }
            return null;
        }
        for (AnchorPointArea a : this.anchorPointAreas) {
            if (a.anchorPoint != element.element.anchorPoint) continue;
            return a;
        }
        return null;
    }

    @Nullable
    protected AbstractEditorElement getTopHoveredNotDraggedElement() {
        List<AbstractEditorElement> childrenOfDragged = this.getChildElementsOfDraggedElements();
        if (childrenOfDragged == null) {
            LOGGER.error("[FANCYMENU] Failed to get hovered element! Error while getting children of dragged elements!", (Throwable)new IllegalStateException());
            return null;
        }
        List<AbstractEditorElement> draggedElements = this.editor.getCurrentlyDraggedElements();
        List<AbstractEditorElement> notDraggedElements = this.editor.getHoveredElements();
        notDraggedElements.removeIf(draggedElements::contains);
        notDraggedElements.removeIf(childrenOfDragged::contains);
        return notDraggedElements.isEmpty() ? null : ListUtils.getLast(notDraggedElements);
    }

    @Nullable
    protected AnchorPointArea getMouseOverArea(int mouseX, int mouseY) {
        AbstractEditorElement e;
        if (FancyMenu.getOptions().anchorOverlayChangeAnchorOnAreaHover.getValue().booleanValue()) {
            for (AnchorPointArea a : this.anchorPointAreas) {
                if (!a.method_25405(mouseX, mouseY)) continue;
                return a;
            }
        }
        if (FancyMenu.getOptions().anchorOverlayChangeAnchorOnElementHover.getValue().booleanValue() && (e = this.getTopHoveredNotDraggedElement()) != null) {
            AbstractElement parentOfHovered = e.element.getElementAnchorPointParent();
            if (parentOfHovered != null) {
                for (AbstractEditorElement dragged : this.editor.getCurrentlyDraggedElements()) {
                    if (!parentOfHovered.getInstanceIdentifier().equals(dragged.element.getInstanceIdentifier())) continue;
                    return null;
                }
            }
            if (!e.isSelected() && !e.isMultiSelected()) {
                return new ElementAnchorPointArea(e.element.getInstanceIdentifier());
            }
        }
        return null;
    }

    protected void setLastCompletedHoverArea(@Nullable AnchorPointArea area) {
        this.lastCompletedHoverArea = area;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.resetAreaHoverCache();
        this.lastTickDraggedEmpty = true;
        this.setLastCompletedHoverArea(null);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keycode, int scancode, int modifiers) {
        String key = GLFW.glfwGetKeyName((int)keycode, (int)scancode);
        if (key == null) {
            key = "";
        }
        if (key.equals("o")) {
            this.overlayVisibilityKeybindPressed = true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    public boolean method_16803(int keycode, int scancode, int modifiers) {
        String key = GLFW.glfwGetKeyName((int)keycode, (int)scancode);
        if (key == null) {
            key = "";
        }
        if (key.equals("o")) {
            this.overlayVisibilityKeybindPressed = false;
        }
        return super.method_16803(keycode, scancode, modifiers);
    }

    public void method_25365(boolean var1) {
    }

    public boolean method_25370() {
        return false;
    }

    public class AnchorPointArea
    implements class_4068,
    class_364 {
        public final ElementAnchorPoint anchorPoint;
        private int x;
        private int y;
        private final int width;
        private final int height;
        private final ProgressDirection direction;

        private AnchorPointArea(ElementAnchorPoint anchorPoint, int width, @NotNull int height, ProgressDirection direction) {
            this.width = width;
            this.height = height;
            this.direction = direction;
            this.anchorPoint = anchorPoint;
        }

        public String toString() {
            return "[anchor_point_area;x=" + this.getX() + ";y=" + this.getY() + ";w=" + this.getWidth() + ";h=" + this.getHeight() + "]";
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            int endX = this.getX() + this.getWidth();
            int endY = this.getY() + this.getHeight();
            graphics.method_25294(this.getX(), this.getY(), endX, endY, RenderingUtils.replaceAlphaInColor(AnchorPointOverlay.this.getOverlayColorBase().getColorInt(), AnchorPointOverlay.this.getOverlayOpacity()));
            UIBase.renderBorder(graphics, (float)this.getX(), (float)this.getY(), (float)endX, (float)endY, 1.0f, RenderingUtils.replaceAlphaInColor(AnchorPointOverlay.this.getOverlayColorBorder().getColorInt(), AnchorPointOverlay.this.getOverlayOpacity()), true, true, true, true);
            UIBase.resetShaderColor(graphics);
        }

        protected void renderMouseOverProgress(@NotNull class_332 graphics, float progress) {
            int progressWidth = (int)((float)this.getWidth() * progress);
            int progressHeight = (int)((float)this.getHeight() * progress);
            int startX = this.getX();
            int startY = this.getY();
            int endX = this.getX() + progressWidth;
            int endY = this.getY() + this.getHeight();
            if (this.direction == ProgressDirection.TO_LEFT) {
                endX = this.getX() + this.getWidth();
                startX = endX - progressWidth;
            } else if (this.direction == ProgressDirection.TO_DOWN) {
                endX = this.getX() + this.getWidth();
                endY = this.getY() + progressHeight;
            } else if (this.direction == ProgressDirection.TO_TOP) {
                endX = this.getX() + this.getWidth();
                startY = endY - progressHeight;
            }
            graphics.method_25294(startX, startY, endX, endY, RenderingUtils.replaceAlphaInColor(AnchorPointOverlay.this.getOverlayColorBorder().getColorInt(), AnchorPointOverlay.this.getOverlayOpacity()));
            UIBase.resetShaderColor(graphics);
        }

        protected int getWidth() {
            return this.width;
        }

        protected int getHeight() {
            return this.height;
        }

        protected int getX() {
            return this.x;
        }

        protected int getY() {
            return this.y;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return UIBase.isXYInArea((int)mouseX, (int)mouseY, this.getX(), this.getY(), this.getWidth(), this.getWidth());
        }

        public void method_25365(boolean var1) {
        }

        public boolean method_25370() {
            return false;
        }

        protected static enum ProgressDirection {
            TO_LEFT,
            TO_RIGHT,
            TO_TOP,
            TO_DOWN;

        }
    }

    public static enum AnchorOverlayVisibilityMode implements LocalizedCycleEnum<AnchorOverlayVisibilityMode>
    {
        DISABLED("disabled"),
        ALWAYS("always"),
        DRAGGING("dragging"),
        KEYBIND("keybind");

        final String name;

        private AnchorOverlayVisibilityMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.editor.anchor_overlay.visibility_mode";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public AnchorOverlayVisibilityMode[] getValues() {
            return AnchorOverlayVisibilityMode.values();
        }

        @Override
        @Nullable
        public AnchorOverlayVisibilityMode getByNameInternal(@NotNull String name) {
            return AnchorOverlayVisibilityMode.getByName(name);
        }

        @Nullable
        public static AnchorOverlayVisibilityMode getByName(@NotNull String name) {
            for (AnchorOverlayVisibilityMode m : AnchorOverlayVisibilityMode.values()) {
                if (!m.name.equals(name)) continue;
                return m;
            }
            return null;
        }
    }

    public class ElementAnchorPointArea
    extends AnchorPointArea {
        @NotNull
        public final String elementIdentifier;

        private ElementAnchorPointArea(String elementIdentifier) {
            super(ElementAnchorPoints.ELEMENT, 0, 0, AnchorPointArea.ProgressDirection.TO_TOP);
            this.elementIdentifier = Objects.requireNonNull(elementIdentifier);
        }

        @Override
        public String toString() {
            return "[element_anchor_point_area;id=" + this.elementIdentifier + ";x=" + this.getX() + ";y=" + this.getY() + ";w=" + this.getWidth() + ";h=" + this.getHeight() + "]";
        }

        @Nullable
        public AbstractEditorElement getElement() {
            AbstractEditorElement element = AnchorPointOverlay.this.editor.getElementByInstanceIdentifier(this.elementIdentifier);
            if (element == null) {
                LOGGER.error("[FANCYMENU] Failed to get element instance of ElementAnchorPointArea! Element was NULL!", (Throwable)new NullPointerException());
            }
            return element;
        }

        @Override
        protected int getX() {
            AbstractEditorElement element = this.getElement();
            return element != null ? element.getX() : -100000;
        }

        @Override
        protected int getY() {
            AbstractEditorElement element = this.getElement();
            return element != null ? element.getY() : -100000;
        }

        @Override
        protected int getWidth() {
            AbstractEditorElement element = this.getElement();
            return element != null ? element.getWidth() : 1;
        }

        @Override
        protected int getHeight() {
            AbstractEditorElement element = this.getElement();
            return element != null ? element.getHeight() : 1;
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            AbstractEditorElement element = this.getElement();
            return element != null ? element.method_25405(mouseX, mouseY) : false;
        }
    }
}

