/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.slider.v2;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonElement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.AbstractExtendedSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.ListSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.RangeSlider;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderElement
extends AbstractElement
implements ExecutableElement {
    public static final String VALUE_PLACEHOLDER = "$$value";
    public AbstractExtendedSlider slider;
    @NotNull
    public SliderType type = SliderType.INTEGER_RANGE;
    @Nullable
    public String preSelectedValue;
    @NotNull
    public List<String> listValues = new ArrayList<String>();
    public double minRangeValue = 1.0;
    public double maxRangeValue = 10.0;
    public int roundingDecimalPlace = 2;
    @Nullable
    public String label;
    public String tooltip;
    public ResourceSupplier<ITexture> handleTextureNormal;
    public ResourceSupplier<ITexture> handleTextureHover;
    public ResourceSupplier<ITexture> handleTextureInactive;
    public ResourceSupplier<ITexture> sliderBackgroundTextureNormal;
    public ResourceSupplier<ITexture> sliderBackgroundTextureHighlighted;
    public boolean restartBackgroundAnimationsOnHover = true;
    public boolean nineSliceCustomBackground = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean nineSliceSliderHandle = false;
    public int nineSliceSliderHandleBorderX = 5;
    public int nineSliceSliderHandleBorderY = 5;
    public boolean navigatable = true;
    @NotNull
    public GenericExecutableBlock executableBlock = new GenericExecutableBlock();
    @NotNull
    public LoadingRequirementContainer activeStateSupplier = new LoadingRequirementContainer();
    public ResourceSupplier<IAudio> hoverSound;

    public SliderElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.buildSlider();
        this.prepareExecutableBlock();
    }

    public void prepareExecutableBlock() {
        this.executableBlock.addValuePlaceholder("value", () -> this.slider != null ? this.slider.getValueDisplayText() : "");
    }

    public void prepareLoadingRequirementContainer() {
        this.loadingRequirementContainer.addValuePlaceholder("value", () -> this.slider != null ? this.slider.getValueDisplayText() : "");
    }

    public void buildSlider() {
        String preSelectedString;
        String string = preSelectedString = this.preSelectedValue != null ? PlaceholderParser.replacePlaceholders(this.preSelectedValue) : null;
        if (this.type == SliderType.INTEGER_RANGE) {
            int min = (int)this.minRangeValue;
            int max = (int)this.maxRangeValue;
            int preSelected = min;
            if (preSelectedString != null && MathUtils.isDouble((String)preSelectedString)) {
                preSelected = (int)Double.parseDouble(preSelectedString);
            }
            this.slider = new RangeSlider(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (class_2561)class_2561.method_43473(), min, max, preSelected);
            ((RangeSlider)this.slider).setShowAsInteger(true);
        }
        if (this.type == SliderType.DECIMAL_RANGE) {
            double preSelected = this.minRangeValue;
            if (preSelectedString != null && MathUtils.isDouble((String)preSelectedString)) {
                preSelected = Double.parseDouble(preSelectedString);
            }
            this.slider = new RangeSlider(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (class_2561)class_2561.method_43473(), this.minRangeValue, this.maxRangeValue, preSelected);
            ((RangeSlider)this.slider).setRoundingDecimalPlace(this.roundingDecimalPlace);
        }
        if (this.type == SliderType.LIST) {
            int preSelectedIndex;
            if (this.listValues.isEmpty()) {
                this.listValues.addAll(List.of("placeholder_1", "placeholder_2"));
            }
            if (this.listValues.size() < 2) {
                this.listValues.add("placeholder_1");
            }
            int n = preSelectedIndex = preSelectedString != null ? this.listValues.indexOf(preSelectedString) : 0;
            if (preSelectedIndex < 0) {
                preSelectedIndex = 0;
            }
            this.slider = new ListSlider<String>(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight(), (class_2561)class_2561.method_43473(), this.listValues, preSelectedIndex);
        }
        if (this.slider != null) {
            this.slider.setLabelSupplier(this::getSliderLabel);
            this.slider.setSliderValueUpdateListener((slider1, valueDisplayText, value) -> this.onChangeSliderValue());
        }
    }

    @NotNull
    protected class_2561 getSliderLabel(@NotNull AbstractExtendedSlider slider) {
        String labelValueReplaced = this.label != null ? this.label.replace(VALUE_PLACEHOLDER, slider.getValueDisplayText()) : "";
        return SliderElement.buildComponent(labelValueReplaced);
    }

    protected void onChangeSliderValue() {
        this.executableBlock.execute();
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        return !SliderElement.isEditor() ? List.of(this.slider) : null;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.slider == null) {
            return;
        }
        this.slider.setNavigatable(this.navigatable);
        this.slider.field_22764 = this.shouldRender();
        this.slider.method_25350(this.getOpacity());
        if (!this.shouldRender()) {
            return;
        }
        this.slider.method_46421(this.getAbsoluteX());
        this.slider.method_46419(this.getAbsoluteY());
        this.slider.method_25358(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)((Object)this.slider)).setHeightFancyMenu(this.getAbsoluteHeight());
        this.updateWidget();
        this.slider.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void updateWidget() {
        if (this.slider == null) {
            return;
        }
        this.updateWidgetHoverSound();
        this.updateWidgetActiveState();
        this.updateWidgetTooltip();
        this.updateWidgetTexture();
        this.slider.method_25346();
    }

    public void updateWidgetHoverSound() {
        AbstractExtendedSlider abstractExtendedSlider = this.slider;
        if (abstractExtendedSlider instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)((Object)abstractExtendedSlider);
            w.setHoverSoundFancyMenu(this.getHoverSound() != null ? this.getHoverSound().get() : null);
        }
    }

    public void updateWidgetActiveState() {
        if (this.slider == null) {
            return;
        }
        this.slider.field_22763 = this.activeStateSupplier.requirementsMet();
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.slider != null && this.slider.method_49606() && this.slider.field_22764 && this.shouldRender() && !SliderElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this.slider, Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetTexture() {
        AbstractExtendedSlider abstractExtendedSlider;
        AbstractExtendedSlider abstractExtendedSlider2;
        RenderableResource sliderBackNormal = null;
        RenderableResource sliderBackHighlighted = null;
        if (this.getSliderBackgroundTextureNormal() != null) {
            sliderBackNormal = this.getSliderBackgroundTextureNormal().get();
        }
        if (this.getSliderBackgroundTextureHighlighted() != null) {
            sliderBackHighlighted = this.getSliderBackgroundTextureHighlighted().get();
        }
        if ((abstractExtendedSlider2 = this.slider) instanceof CustomizableSlider) {
            CustomizableSlider w = (CustomizableSlider)((Object)abstractExtendedSlider2);
            w.setCustomSliderBackgroundNormalFancyMenu(sliderBackNormal);
            w.setCustomSliderBackgroundHighlightedFancyMenu(sliderBackHighlighted);
        }
        RenderableResource handleTextureNormal = null;
        RenderableResource handleTextureHover = null;
        RenderableResource handleTextureInactive = null;
        if (this.getHandleTextureNormal() != null) {
            handleTextureNormal = this.getHandleTextureNormal().get();
        }
        if (this.getHandleTextureHover() != null) {
            handleTextureHover = this.getHandleTextureHover().get();
        }
        if (this.getHandleTextureInactive() != null) {
            handleTextureInactive = this.getHandleTextureInactive().get();
        }
        if ((abstractExtendedSlider = this.slider) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)((Object)abstractExtendedSlider);
            AbstractExtendedSlider abstractExtendedSlider3 = this.slider;
            if (abstractExtendedSlider3 instanceof CustomizableSlider) {
                CustomizableSlider s = (CustomizableSlider)((Object)abstractExtendedSlider3);
                s.setNineSliceCustomSliderBackground_FancyMenu(this.isNineSliceCustomBackground());
                s.setNineSliceSliderBackgroundBorderX_FancyMenu(this.getNineSliceBorderX());
                s.setNineSliceSliderBackgroundBorderY_FancyMenu(this.getNineSliceBorderY());
                s.setNineSliceCustomSliderHandle_FancyMenu(this.isNineSliceSliderHandle());
                s.setNineSliceSliderHandleBorderX_FancyMenu(this.getNineSliceSliderHandleBorderX());
                s.setNineSliceSliderHandleBorderY_FancyMenu(this.getNineSliceSliderHandleBorderY());
            }
            w.setCustomBackgroundNormalFancyMenu(handleTextureNormal);
            w.setCustomBackgroundHoverFancyMenu(handleTextureHover);
            w.setCustomBackgroundInactiveFancyMenu(handleTextureInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.isRestartBackgroundAnimationsOnHover() ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.executableBlock;
    }

    @Override
    public int getAbsoluteWidth() {
        ButtonElement template;
        if (this.isTemplateActive() && (template = this.getPropertySource()) != null && template.templateApplyWidth) {
            return template.getAbsoluteWidth();
        }
        return super.getAbsoluteWidth();
    }

    @Override
    public int getAbsoluteHeight() {
        ButtonElement template;
        if (this.isTemplateActive() && (template = this.getPropertySource()) != null && template.templateApplyHeight) {
            return template.getAbsoluteHeight();
        }
        return super.getAbsoluteHeight();
    }

    @Override
    public int getAbsoluteX() {
        ButtonElement template;
        if (this.isTemplateActive() && (template = this.getPropertySource()) != null && template.templateApplyPosX) {
            return template.getAbsoluteX();
        }
        return super.getAbsoluteX();
    }

    @Override
    public int getAbsoluteY() {
        ButtonElement template;
        if (this.isTemplateActive() && (template = this.getPropertySource()) != null && template.templateApplyPosY) {
            return template.getAbsoluteY();
        }
        return super.getAbsoluteY();
    }

    @Override
    public boolean shouldRender() {
        ButtonElement template;
        if (this.isTemplateActive() && (template = this.getPropertySource()) != null && template.templateApplyVisibility) {
            return template.shouldRender();
        }
        return super.shouldRender();
    }

    public ResourceSupplier<IAudio> getHoverSound() {
        return this.getTemplateProperty(template -> template.hoverSound, this.hoverSound);
    }

    public ResourceSupplier<ITexture> getHandleTextureNormal() {
        return this.getTemplateProperty(template -> template.backgroundTextureNormal, this.handleTextureNormal);
    }

    public ResourceSupplier<ITexture> getHandleTextureHover() {
        return this.getTemplateProperty(template -> template.backgroundTextureHover, this.handleTextureHover);
    }

    public ResourceSupplier<ITexture> getHandleTextureInactive() {
        return this.getTemplateProperty(template -> template.backgroundTextureInactive, this.handleTextureInactive);
    }

    public ResourceSupplier<ITexture> getSliderBackgroundTextureNormal() {
        return this.getTemplateProperty(template -> template.sliderBackgroundTextureNormal, this.sliderBackgroundTextureNormal);
    }

    public ResourceSupplier<ITexture> getSliderBackgroundTextureHighlighted() {
        return this.getTemplateProperty(template -> template.sliderBackgroundTextureHighlighted, this.sliderBackgroundTextureHighlighted);
    }

    public boolean isRestartBackgroundAnimationsOnHover() {
        return this.getTemplateProperty(template -> template.restartBackgroundAnimationsOnHover, this.restartBackgroundAnimationsOnHover);
    }

    public boolean isNineSliceCustomBackground() {
        return this.getTemplateProperty(template -> template.nineSliceCustomBackground, this.nineSliceCustomBackground);
    }

    public int getNineSliceBorderX() {
        return this.getTemplateProperty(template -> template.nineSliceBorderX, this.nineSliceBorderX);
    }

    public int getNineSliceBorderY() {
        return this.getTemplateProperty(template -> template.nineSliceBorderY, this.nineSliceBorderY);
    }

    public boolean isNineSliceSliderHandle() {
        return this.getTemplateProperty(template -> template.nineSliceSliderHandle, this.nineSliceSliderHandle);
    }

    public int getNineSliceSliderHandleBorderX() {
        return this.getTemplateProperty(template -> template.nineSliceSliderHandleBorderX, this.nineSliceSliderHandleBorderX);
    }

    public int getNineSliceSliderHandleBorderY() {
        return this.getTemplateProperty(template -> template.nineSliceSliderHandleBorderY, this.nineSliceSliderHandleBorderY);
    }

    public float getOpacity() {
        ButtonElement template = this.getPropertySource();
        if (template != null && template.templateApplyOpacity) {
            return template.opacity;
        }
        return this.opacity;
    }

    @Nullable
    public String getLabel() {
        ButtonElement template = this.getPropertySource();
        if (template != null && template.templateApplyLabel) {
            return template.label;
        }
        return this.label;
    }

    protected <T> T getTemplateProperty(@NotNull TemplatePropertyGetter<T> templatePropertyGetter, @Nullable T defaultProperty) {
        if (this.getPropertySource() != null) {
            return templatePropertyGetter.get(this.getPropertySource());
        }
        return defaultProperty;
    }

    @Nullable
    public ButtonElement getPropertySource() {
        ButtonElement template = ButtonElement.getTopActiveTemplateElement(true);
        if (template != null) {
            if (template.templateShareWith == ButtonElement.TemplateSharing.BUTTONS) {
                return null;
            }
            return template;
        }
        return null;
    }

    public boolean isTemplateActive() {
        return this.getPropertySource() != null;
    }

    public static enum SliderType implements LocalizedCycleEnum<SliderType>
    {
        LIST("list"),
        INTEGER_RANGE("integer_range"),
        DECIMAL_RANGE("decimal_range");

        final String name;

        private SliderType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public SliderType[] getValues() {
            return SliderType.values();
        }

        @Override
        @Nullable
        public SliderType getByNameInternal(@NotNull String name) {
            return SliderType.getByName(name);
        }

        @Nullable
        public static SliderType getByName(@NotNull String name) {
            for (SliderType i : SliderType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.slider.v2.type";
        }
    }

    @FunctionalInterface
    protected static interface TemplatePropertyGetter<T> {
        public T get(@NotNull ButtonElement var1);
    }
}

