/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.networking;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.util.SkinShufflePlayer;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerSkinHandling {
    private static void handleSkinRefresh(MinecraftServer server, class_3222 player, Property skinData) {
        SkinShuffle.LOGGER.info("Recieved skin refresh packet from: " + player.method_5477().getString());
        server.execute(() -> {
            PropertyMap properties = player.method_7334().getProperties();
            try {
                properties.removeAll((Object)"textures");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                properties.put((Object)"textures", (Object)skinData);
            }
            catch (Error e) {
                SkinShuffle.LOGGER.error("Failed to refresh GameProfile for " + String.valueOf(player.method_5477()) + "\n" + e.getMessage());
            }
            SkinShufflePlayer skinShufflePlayer = (SkinShufflePlayer)player;
            skinShufflePlayer.skinShuffle$refreshSkin();
        });
    }

    public static boolean attemptPlayerListEntryRefresh(class_3222 player, int entityID) {
        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)SkinShuffle.id("refresh_player_list_entry"))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SkinShuffle.id("refresh_player_list_entry"), (class_2540)PacketByteBufs.create().method_10804(entityID));
            return true;
        }
        return false;
    }

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (ServerPlayNetworking.canSend((class_3222)handler.method_32311(), (class_2960)SkinShuffle.id("handshake"))) {
                ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_2960)SkinShuffle.id("handshake"), (class_2540)PacketByteBufs.empty());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SkinShuffle.id("refresh"), (server, player, handler, buf, responseSender) -> {
            try {
                ServerSkinHandling.handleSkinRefresh(server, player, buf.method_43624());
            }
            catch (Exception e) {
                SkinShuffle.LOGGER.error("Failed to handle skin refresh packet from " + player.method_5477().getString() + "\n" + e.getMessage());
            }
        });
    }
}

