/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.skin;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.api.SkinAPIs;
import com.mineblock11.skinshuffle.api.SkinQueryResult;
import com.mineblock11.skinshuffle.client.skin.UrlSkin;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class UUIDSkin
extends UrlSkin {
    public static final class_2960 SERIALIZATION_ID = SkinShuffle.id("uuid");
    public static final Codec<UUIDSkin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("uuid").forGetter(skin -> skin.uuid.toString()), (App)Codec.STRING.optionalFieldOf("model").forGetter(skin -> Optional.ofNullable(skin.model))).apply((Applicative)instance, (uuid, model) -> new UUIDSkin(UUID.fromString(uuid), (String)model.orElse(null))));
    protected UUID uuid;

    public UUIDSkin(UUID uuid, @Nullable String model) {
        super(model);
        this.uuid = uuid;
    }

    protected UUIDSkin(@Nullable String model) {
        super(model);
    }

    @Override
    protected Object getTextureUniqueness() {
        return this.uuid;
    }

    @Override
    @Nullable
    protected class_1044 loadTexture(Runnable completionCallback) {
        SkinQueryResult profile = SkinAPIs.getPlayerSkinTexture(this.uuid.toString());
        if (profile.skinURL() == null) {
            return null;
        }
        this.url = profile.skinURL();
        if (this.model == null) {
            this.model = profile.modelType();
            this.cacheModel();
        }
        return super.loadTexture(completionCallback);
    }

    @Override
    public class_2960 getSerializationId() {
        return SERIALIZATION_ID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UUIDSkin uuidSkin = (UUIDSkin)o;
        return Objects.equals(this.uuid, uuidSkin.uuid) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }
}

