/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.skin;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.client.skin.BackedSkin;
import com.mineblock11.skinshuffle.client.skin.ConfigSkin;
import com.mineblock11.skinshuffle.util.LegacySkinConverter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import org.jetbrains.annotations.Nullable;

public abstract class FileBackedSkin
extends BackedSkin {
    @Nullable
    private Boolean exists;

    @Override
    protected Object getTextureUniqueness() {
        return this.getFile();
    }

    @Override
    @Nullable
    protected class_1044 loadTexture(Runnable completionCallback) {
        class_1043 class_10432;
        block9: {
            InputStream inputStream = Files.newInputStream(this.getFile(), new OpenOption[0]);
            try {
                class_1011 image = LegacySkinConverter.processTexture(class_1011.method_4310((class_1011.class_1012)class_1011.class_1012.field_4997, (InputStream)inputStream));
                if (image == null) {
                    throw new RuntimeException("Texture is null!");
                }
                class_1043 texture = new class_1043(image);
                completionCallback.run();
                class_10432 = texture;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SkinShuffle.LOGGER.warn("Failed to load skin from file: " + String.valueOf(this.getFile()), (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10432;
    }

    public void delete() {
        if (this.fileExists()) {
            try {
                Files.delete(this.getFile());
                this.exists = false;
                this.setTexture(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean fileExists() {
        if (this.exists == null) {
            this.exists = Files.isReadable(this.getFile());
        }
        return this.exists;
    }

    protected abstract Path getFile();

    @Override
    public ConfigSkin saveToConfig() {
        try {
            String textureName = String.valueOf(Math.abs(this.getTextureUniqueness().hashCode()));
            ConfigSkin configSkin = new ConfigSkin(textureName, this.getModel());
            Files.copy(this.getFile(), configSkin.getFile(), StandardCopyOption.REPLACE_EXISTING);
            return configSkin;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save skin to config", e);
        }
    }
}

