/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.skin;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.client.skin.Skin;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public abstract class BackedSkin
implements Skin {
    public static final Object2IntMap<class_2960> INSTANCE_COUNTS = new Object2IntOpenHashMap();
    private boolean fetching = false;
    private boolean fetched = false;
    @Nullable
    private class_2960 textureId;

    public void fetchSkin() {
        class_2960 id = SkinShuffle.id("skin/" + this.getSerializationId().method_12832() + "/" + Math.abs(this.getTextureUniqueness().hashCode()));
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (textureManager.method_34590(id, null) == null) {
            this.fetching = true;
            CompletableFuture.runAsync(() -> {
                try {
                    class_1044 texture = this.loadTexture(() -> {
                        this.fetching = false;
                        this.fetched = true;
                        this.setTexture(id);
                    });
                    if (texture != null) {
                        textureManager.method_4616(id, texture);
                    } else {
                        this.fetching = false;
                        this.fetched = true;
                        this.setTexture(null);
                    }
                }
                catch (Exception e) {
                    SkinShuffle.LOGGER.warn("Failed to load skin texture", (Throwable)e);
                    this.fetching = false;
                    this.fetched = true;
                    this.setTexture(null);
                }
            }, class_156.method_18349());
        } else {
            this.fetched = true;
            this.setTexture(id);
        }
    }

    @Override
    @Nullable
    public class_2960 getTexture() {
        if (this.textureId == null && !this.fetching && !this.fetched) {
            this.fetchSkin();
        }
        return this.textureId;
    }

    @Override
    public boolean isLoading() {
        return !this.fetched || this.fetching;
    }

    protected void setTexture(class_2960 textureId) {
        if (this.textureId != null) {
            BackedSkin.decrementInstanceCountAndCleanup(this.textureId);
        }
        this.textureId = textureId;
        BackedSkin.incrementInstanceCount(textureId);
    }

    protected abstract Object getTextureUniqueness();

    @Nullable
    protected abstract class_1044 loadTexture(Runnable var1);

    protected void finalize() throws Throwable {
        try {
            if (this.textureId != null) {
                BackedSkin.decrementInstanceCountAndCleanup(this.textureId);
            }
        }
        finally {
            super.finalize();
        }
    }

    private static void incrementInstanceCount(class_2960 id) {
        INSTANCE_COUNTS.compute((Object)id, (k, v) -> v == null ? 1 : v + 1);
    }

    public static void decrementInstanceCountAndCleanup(class_2960 id) {
        INSTANCE_COUNTS.compute((Object)id, (k, v) -> v == null ? 0 : v - 1);
        if (INSTANCE_COUNTS.getInt((Object)id) == 0) {
            class_310.method_1551().method_1531().method_4615(id);
            INSTANCE_COUNTS.removeInt((Object)id);
        }
    }
}

