/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.preset;

import com.mineblock11.skinshuffle.api.SkinAPIs;
import com.mineblock11.skinshuffle.api.SkinQueryResult;
import com.mineblock11.skinshuffle.client.skin.ResourceSkin;
import com.mineblock11.skinshuffle.client.skin.Skin;
import com.mineblock11.skinshuffle.client.skin.UrlSkin;
import com.mineblock11.skinshuffle.util.NetworkingUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class SkinPreset {
    public static final Codec<SkinPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Skin.CODEC.fieldOf("skin").forGetter(SkinPreset::getSkin), (App)Codec.STRING.fieldOf("name").forGetter(SkinPreset::getName)).apply((Applicative)instance, SkinPreset::new));
    private String name;
    private Skin skin;

    public SkinPreset(Skin skin) {
        this(skin, "Unnamed Preset");
    }

    public SkinPreset(Skin skin, String name) {
        this.skin = skin;
        this.name = name;
    }

    public static SkinPreset generateDefaultPreset() {
        class_310 client = class_310.method_1551();
        class_320 session = client.method_1548();
        String name = session.method_1676();
        if (!NetworkingUtil.isLoggedIn()) {
            class_2960 skinTexture;
            ResourceSkin skin = new ResourceSkin(skinTexture, (skinTexture = client.method_1582().method_44705(session.method_1677())).method_12832().contains("/slim/") ? "slim" : "classic");
            return new SkinPreset(skin, name);
        }
        SkinQueryResult skinQueryResult = SkinAPIs.getPlayerSkinTexture(session.method_1673());
        if (skinQueryResult.usesDefaultSkin()) {
            class_2960 skinTexture;
            ResourceSkin skin = new ResourceSkin(skinTexture, (skinTexture = client.method_1582().method_44705(session.method_1677())).method_12832().contains("/slim/") ? "slim" : "classic");
            return new SkinPreset(skin, name);
        }
        return new SkinPreset(new UrlSkin(skinQueryResult.skinURL(), skinQueryResult.modelType()), name);
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void copyFrom(SkinPreset other) {
        this.name = other.name;
        this.skin = other.skin;
    }

    public SkinPreset copy() {
        return new SkinPreset(this.skin, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinPreset that = (SkinPreset)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.skin.equals(that.skin);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.skin.hashCode();
        return result;
    }
}

