/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.gui;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.client.SkinShuffleClient;
import com.mineblock11.skinshuffle.client.config.SkinPresetManager;
import com.mineblock11.skinshuffle.client.config.SkinShuffleConfig;
import com.mineblock11.skinshuffle.client.gui.CarouselScreen;
import com.mineblock11.skinshuffle.client.gui.cursed.GuiEntityRenderer;
import com.mineblock11.skinshuffle.client.gui.widgets.IconButtonWidget;
import com.mineblock11.skinshuffle.client.gui.widgets.preset.PresetWidget;
import com.mineblock11.skinshuffle.client.preset.SkinPreset;
import com.mineblock11.skinshuffle.client.skin.FileSkin;
import com.mineblock11.skinshuffle.client.skin.ResourceSkin;
import com.mineblock11.skinshuffle.client.skin.Skin;
import com.mineblock11.skinshuffle.client.skin.UUIDSkin;
import com.mineblock11.skinshuffle.client.skin.UrlSkin;
import com.mineblock11.skinshuffle.client.skin.UsernameSkin;
import com.mineblock11.skinshuffle.util.ToastHelper;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import java.awt.Color;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3673;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8086;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import org.apache.commons.validator.routines.UrlValidator;

public class PresetEditScreen
extends SpruceScreen {
    public static final int MAX_WIDTH = 400;
    private final CarouselScreen parent;
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"});
    private final SkinPreset originalPreset;
    private final SkinPreset preset;
    private final PresetWidget<?> presetWidget;
    private class_8089 tabNavigation;
    private SkinSourceTab skinSourceTab;
    private SkinCustomizationTab skinCustomizationTab;
    private boolean isValid = true;
    private class_7845 grid;
    private class_4185 exitButton;
    private int sideMargins;

    public PresetEditScreen(PresetWidget<?> presetWidget, CarouselScreen parent, SkinPreset preset) {
        super((class_2561)class_2561.method_43471((String)"skinshuffle.edit.title"));
        this.presetWidget = presetWidget;
        this.preset = preset.copy();
        this.originalPreset = preset;
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.skinSourceTab = new SkinSourceTab();
        this.skinCustomizationTab = new SkinCustomizationTab();
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{this.skinSourceTab, this.skinCustomizationTab}).method_48627();
        this.method_37063((class_364)this.tabNavigation);
        this.tabNavigation.method_48987(0, false);
        this.grid = new class_7845().method_48635(10);
        class_7845.class_7939 adder = this.grid.method_47610(2);
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46431());
        this.exitButton = class_4185.method_46430((class_2561)class_5244.field_44914, button -> {
            if (this.skinSourceTab.currentSourceType != SourceType.UNCHANGED) {
                if (this.skinSourceTab.currentSourceType == SourceType.FILE) {
                    Object pathStr = this.skinSourceTab.textFieldWidget.method_1882();
                    if (((String)pathStr).startsWith("~")) {
                        String home = System.getProperty("user.home");
                        pathStr = home + ((String)pathStr).substring(1);
                    }
                    this.skinSourceTab.textFieldWidget.method_1852((String)pathStr);
                }
                if (this.skinSourceTab.currentSourceType == SourceType.FILE || this.skinSourceTab.currentSourceType == SourceType.URL) {
                    String sre = this.skinSourceTab.textFieldWidget.method_1882();
                    if (sre.startsWith("\"") && sre.endsWith("\"")) {
                        sre = sre.substring(1, sre.length() - 1);
                    }
                    this.skinSourceTab.textFieldWidget.method_1852(sre);
                }
            }
            this.originalPreset.copyFrom(this.preset);
            try {
                this.originalPreset.setSkin(this.preset.getSkin().saveToConfig());
            }
            catch (Exception exception) {
                // empty catch block
            }
            SkinPresetManager.savePresets();
            this.parent.hasEditedPreset = true;
            this.method_25419();
        }).method_46431();
        adder.method_47612((class_8021)this.exitButton);
        this.grid.method_48206(child -> {
            child.method_48591(1);
            this.method_37063((class_364)child);
        });
        this.method_48640();
    }

    protected void method_48640() {
        this.sideMargins = Math.max(this.field_22789 - 400, 0) / 2;
        if (this.tabNavigation != null && this.grid != null) {
            this.tabNavigation.method_48618(this.field_22789);
            this.tabNavigation.method_49613();
            this.grid.method_48222();
            class_7843.method_46442((class_8021)this.grid, (int)0, (int)(this.field_22790 - 36), (int)this.field_22789, (int)36);
            int i = this.tabNavigation.method_48202().method_49619();
            class_8030 screenRect = new class_8030(0, i, this.field_22789, this.grid.method_46427() - i);
            this.tabManager.method_48616(screenRect);
        }
        this.updateValidity();
    }

    private boolean isValidPngFilePath(String pathStr) {
        Path path;
        if (((String)(pathStr = ((String)pathStr).trim())).startsWith("\"") && ((String)pathStr).endsWith("\"")) {
            pathStr = ((String)pathStr).substring(1, ((String)pathStr).length() - 1);
        }
        if (((String)pathStr).startsWith("~")) {
            String home = System.getProperty("user.home");
            pathStr = home + ((String)pathStr).substring(1);
        }
        if (Files.exists(path = Paths.get((String)pathStr, new String[0]), new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            String fileName = path.getFileName().toString().toLowerCase();
            return fileName.endsWith(".png");
        }
        return false;
    }

    private boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    private boolean isValidUsername(String username) {
        return username.matches("([a-zA-Z0-9]|_)*") && username.length() >= 3 && username.length() <= 16;
    }

    public boolean validate() {
        if (this.skinCustomizationTab != null && this.skinSourceTab != null) {
            SourceType type = this.skinSourceTab.currentSourceType;
            class_342 widget = this.skinSourceTab.textFieldWidget;
            switch (type.ordinal()) {
                case 3: {
                    return this.urlValidator.isValid(widget.method_1882());
                }
                case 5: {
                    try {
                        return this.isValidPngFilePath(widget.method_1882());
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                }
                case 4: {
                    if (class_2960.method_20207((String)widget.method_1882())) {
                        return this.field_22787.method_1478().method_14486(new class_2960(widget.method_1882())).isPresent();
                    }
                    return false;
                }
                case 1: {
                    return this.isValidUsername(widget.method_1882());
                }
                case 2: {
                    return this.isValidUUID(widget.method_1882());
                }
            }
            return false;
        }
        return false;
    }

    private void updateValidity() {
        if (this.skinSourceTab.currentSourceType != SourceType.UNCHANGED) {
            this.isValid = this.validate();
            if (!this.isValid) {
                this.skinSourceTab.errorLabel.method_25355(this.skinSourceTab.currentSourceType.getInvalidInputText());
            } else {
                this.skinSourceTab.errorLabel.method_25355((class_2561)class_2561.method_43473());
            }
            this.grid.method_48222();
        }
        this.skinSourceTab.textFieldWidget.method_1862(this.skinSourceTab.currentSourceType != SourceType.UNCHANGED);
        this.skinSourceTab.loadButton.field_22764 = this.skinSourceTab.currentSourceType != SourceType.UNCHANGED;
        this.skinSourceTab.loadButton.field_22763 = this.skinSourceTab.currentSourceType != SourceType.UNCHANGED && this.isValid;
        this.skinSourceTab.skinModelButton.field_22764 = this.skinSourceTab.currentSourceType != SourceType.UNCHANGED;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        int ratioMulTen = 16;
        int topBottomMargin = 40;
        int leftRightMargin = 20;
        int previewSpanX = 66 - leftRightMargin;
        int previewSpanY = Math.min(this.field_22790 - topBottomMargin * 2, previewSpanX * 2 * ratioMulTen / 10) / 2;
        int previewCenterX = 66 + this.sideMargins;
        int previewCenterY = Math.max(this.field_22790 / 4 + previewSpanY / 2, 120);
        graphics.method_49601(previewCenterX - previewSpanX, previewCenterY - previewSpanY, previewSpanX * 2, previewSpanY * 2, -553648128);
        graphics.method_25294(previewCenterX - previewSpanX + 1, previewCenterY - previewSpanY + 1, previewCenterX + previewSpanX - 1, previewCenterY + previewSpanY - 1, 0x7F000000);
        if (!this.preset.getSkin().isLoading()) {
            int entityX = previewCenterX;
            int entityY = previewCenterY + previewSpanY / 10 * 8 + 30;
            float followX = entityX - mouseX;
            float followY = (float)entityY - (float)previewSpanY * 1.2f - (float)mouseY - 10.0f;
            float rotation = 0.0f;
            SkinShuffleConfig.SkinRenderStyle renderStyle = SkinShuffleConfig.get().presetEditScreenRenderStyle;
            if (renderStyle.equals((Object)SkinShuffleConfig.SkinRenderStyle.ROTATION)) {
                followX = 0.0f;
                followY = 0.0f;
                rotation = this.getEntityRotation() * SkinShuffleConfig.get().rotationMultiplier;
            }
            if (!this.preset.getSkin().isLoading() && !this.skinSourceTab.loading) {
                graphics.method_51448().method_22903();
                GuiEntityRenderer.drawEntity(graphics.method_51448(), entityX, entityY, previewSpanY / 10 * 8, rotation, followX, followY, this.preset.getSkin(), renderStyle);
                graphics.method_51448().method_22909();
            } else {
                class_5250 txt = class_2561.method_43471((String)"skinshuffle.edit.loading");
                int textWidth = this.field_22793.method_27525((class_5348)txt);
                float totalDeltaTick = SkinShuffleClient.TOTAL_TICK_DELTA * 5.0f;
                float hue = totalDeltaTick % 360.0f / 360.0f;
                float saturation = 0.75f;
                float lightness = 1.0f;
                int color = Color.HSBtoRGB(hue, saturation, lightness);
                color = color & 0xFFFFFF | 0xFF000000;
                int n = previewCenterX - textWidth / 2;
                Objects.requireNonNull(this.field_22793);
                graphics.method_27535(this.field_22793, (class_2561)txt, n, previewCenterY - 9, color);
            }
        } else {
            this.preset.getSkin().getTexture();
        }
        this.exitButton.field_22763 = !this.preset.equals(this.originalPreset);
    }

    public void method_25434(class_332 context) {
        context.method_25291(class_525.field_44672, 0, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, 32, 32);
    }

    private float getEntityRotation() {
        return (float)class_3673.method_15974() * 35.0f;
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parent);
    }

    private class SkinSourceTab
    extends class_8086 {
        private final class_342 textFieldWidget;
        private final class_7940 errorLabel;
        public SourceType currentSourceType;
        private final class_5676<String> skinModelButton;
        private final class_4185 loadButton;
        private boolean loading;

        private SkinSourceTab() {
            super((class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.title"));
            this.loading = false;
            this.field_42139.method_46458().method_46469(133 + PresetEditScreen.this.sideMargins).method_46473(PresetEditScreen.this.sideMargins).method_46467();
            class_7845.class_7939 gridAdder = this.field_42139.method_48636(4).method_47610(1);
            this.currentSourceType = SourceType.UNCHANGED;
            this.textFieldWidget = new class_342(PresetEditScreen.this.field_22793, 0, 0, 230, 20, (class_2561)class_2561.method_43473());
            this.textFieldWidget.method_1880(2048);
            this.errorLabel = new class_7940(0, 0, (class_2561)class_2561.method_43473(), PresetEditScreen.this.field_22793){

                public int method_25364() {
                    Objects.requireNonNull(PresetEditScreen.this.field_22793);
                    int minHeight = 9 * 5;
                    return Math.max(super.method_25364(), minHeight);
                }
            };
            this.loadButton = new IconButtonWidget(0, 0, 20, 20, 0, 0, 0, 2, 32, 16, 16, 16, 48, SkinShuffle.id("textures/gui/reload-button-icon.png"), button -> {
                if (this.currentSourceType != SourceType.UNCHANGED) {
                    if (this.currentSourceType == SourceType.FILE) {
                        Object pathStr = this.textFieldWidget.method_1882();
                        if (((String)pathStr).startsWith("~")) {
                            String home = System.getProperty("user.home");
                            pathStr = home + ((String)pathStr).substring(1);
                        }
                        this.textFieldWidget.method_1852((String)pathStr);
                    }
                    if (this.currentSourceType == SourceType.FILE || this.currentSourceType == SourceType.URL) {
                        String sre = this.textFieldWidget.method_1882();
                        if (sre.startsWith("\"") && sre.endsWith("\"")) {
                            sre = sre.substring(1, sre.length() - 1);
                        }
                        this.textFieldWidget.method_1852(sre);
                    }
                    this.loadSkin();
                }
            });
            this.textFieldWidget.method_1863(str -> PresetEditScreen.this.updateValidity());
            this.skinModelButton = new class_5676.class_5677(class_2561::method_30163).method_32624((Object[])new String[]{"classic", "slim"}).method_32617(0, 0, 192, 20, (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.skin_model"), (widget, val) -> {
                SkinPreset preset = PresetEditScreen.this.preset;
                preset.getSkin().setModel((String)val);
            });
            if (this.currentSourceType != null) {
                gridAdder.method_47615((class_8021)new class_5676(0, 0, 192, 20, (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.cycle_prefix").method_27693(": ").method_10852(this.currentSourceType.getTranslation()), (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.cycle_prefix"), Arrays.stream(SourceType.values()).toList().indexOf((Object)this.currentSourceType), (Object)this.currentSourceType, class_5676.class_5680.method_32627(List.of(SourceType.values())), SourceType::getTranslation, sourceTypeCyclingButtonWidget -> class_2561.method_30163((String)"").method_27661(), (button, value) -> {
                    this.currentSourceType = value;
                    this.errorLabel.method_25355((class_2561)class_2561.method_43473());
                    PresetEditScreen.this.updateValidity();
                }, value -> null, false), this.field_42139.method_46457().method_46471(Math.min(PresetEditScreen.this.field_22790 / 2 - 60, 20)));
            } else {
                ToastHelper.showEditorFailToast();
                PresetEditScreen.this.method_25419();
            }
            gridAdder.method_47612(this.skinModelButton);
            class_7845 subGrid = new class_7845();
            class_7845.class_7939 subGridAdder = subGrid.method_48635(4).method_47610(2);
            gridAdder.method_47615((class_8021)subGrid, this.field_42139.method_46457().method_46471(6).method_46475(6));
            subGridAdder.method_47612((class_8021)this.textFieldWidget);
            subGridAdder.method_47612((class_8021)this.loadButton);
            gridAdder.method_47615((class_8021)this.errorLabel, this.field_42139.method_46457().method_46461());
        }

        private void loadSkin() {
            this.loading = true;
            String skinSource = this.textFieldWidget.method_1882();
            String model = (String)this.skinModelButton.method_32603();
            if (!skinSource.isEmpty() && this.currentSourceType != SourceType.UNCHANGED) {
                Skin skin = switch (this.currentSourceType.ordinal()) {
                    case 3 -> new UrlSkin(skinSource, model);
                    case 5 -> new FileSkin(Path.of(skinSource, new String[0]), model);
                    case 2 -> new UUIDSkin(UUID.fromString(skinSource), model);
                    case 1 -> new UsernameSkin(skinSource, model);
                    case 4 -> new ResourceSkin(class_2960.method_12829((String)skinSource), model);
                    default -> Skin.randomDefaultSkin();
                };
                CompletableFuture.runAsync(() -> {
                    PresetEditScreen.this.preset.setSkin(skin.saveToConfig());
                    skin.getTexture();
                    while (PresetEditScreen.this.preset.getSkin().isLoading()) {
                        Thread.onSpinWait();
                    }
                    this.loading = false;
                }, class_156.method_27958());
            }
        }
    }

    private class SkinCustomizationTab
    extends class_8086 {
        public SkinCustomizationTab() {
            super((class_2561)class_2561.method_43471((String)"skinshuffle.edit.customize.title"));
            this.field_42139.method_46458().method_46469(PresetEditScreen.this.parent.field_22789 / 3).method_46467();
            class_7845.class_7939 gridAdder = this.field_42139.method_48636(8).method_47610(1);
            class_342 presetNameField = new class_342(PresetEditScreen.this.field_22793, 0, 0, 256, 20, (class_2561)class_2561.method_43473());
            presetNameField.method_1852(PresetEditScreen.this.preset.getName());
            presetNameField.method_1863(PresetEditScreen.this.preset::setName);
            presetNameField.method_1880(2048);
            gridAdder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"skinshuffle.edit.customize.preset_name"), PresetEditScreen.this.field_22793));
            gridAdder.method_47612((class_8021)presetNameField);
        }
    }

    private static enum SourceType {
        UNCHANGED,
        USERNAME,
        UUID,
        URL,
        RESOURCE_LOCATION,
        FILE;


        public class_2561 getInvalidInputText() {
            return class_2561.method_43471((String)("skinshuffle.edit.source.invalid_" + this.name().toLowerCase()));
        }

        public class_2561 getTranslation() {
            return class_2561.method_43471((String)("skinshuffle.edit.source." + this.name().toLowerCase()));
        }
    }
}

