/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.gui;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.client.config.CarouselView;
import com.mineblock11.skinshuffle.client.config.SkinPresetManager;
import com.mineblock11.skinshuffle.client.config.SkinShuffleConfig;
import com.mineblock11.skinshuffle.client.gui.GeneratedScreens;
import com.mineblock11.skinshuffle.client.gui.widgets.ActualSpruceIconButtonWidget;
import com.mineblock11.skinshuffle.client.gui.widgets.preset.AbstractCardWidget;
import com.mineblock11.skinshuffle.client.gui.widgets.preset.AddCardWidget;
import com.mineblock11.skinshuffle.client.gui.widgets.preset.PresetWidget;
import com.mineblock11.skinshuffle.client.preset.SkinPreset;
import com.mineblock11.skinshuffle.client.skin.ConfigSkin;
import com.mineblock11.skinshuffle.client.skin.Skin;
import com.mineblock11.skinshuffle.networking.ClientSkinHandling;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.util.ScissorManager;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceIconButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3673;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5481;

public abstract class CarouselScreen
extends SpruceScreen {
    public final class_437 parent;
    public final CarouselView viewType;
    public final CarouselView nextViewType;
    public boolean hasEditedPreset = false;
    protected SpruceIconButtonWidget configButton;
    protected SpruceIconButtonWidget viewTypeButton;
    private double cardIndex = -1.0;
    private double lastCardIndex = 0.0;
    private double lastCardSwitchTime = 0.0;
    public ArrayList<AbstractCardWidget<?>> carouselWidgets = new ArrayList();
    protected SpruceButtonWidget cancelButton;
    protected SpruceButtonWidget selectButton;

    public CarouselScreen(class_437 parent, CarouselView viewType, CarouselView nextViewType) {
        super((class_2561)class_2561.method_43471((String)"skinshuffle.carousel.title"));
        this.parent = parent;
        this.viewType = viewType;
        this.nextViewType = nextViewType;
    }

    protected void method_25426() {
        super.method_25426();
        this.carouselWidgets.clear();
        List<SkinPreset> loadedPresets = SkinPresetManager.getLoadedPresets();
        for (SkinPreset preset : loadedPresets) {
            AbstractCardWidget abstractCardWidget = this.widgetFromPreset(preset);
            this.carouselWidgets.add(abstractCardWidget);
        }
        AddCardWidget addPresetWidget = new AddCardWidget(this, Position.of((int)0, (int)0), this.getCardWidth(), this.getCardHeight());
        addPresetWidget.setCallback(() -> {
            SkinPreset unnamed = new SkinPreset(Skin.randomDefaultSkin());
            SkinPresetManager.addPreset(unnamed);
            AbstractCardWidget newWidget = this.loadPreset(unnamed);
            this.method_37063((class_364)newWidget);
        });
        this.carouselWidgets.add(addPresetWidget);
        if (!loadedPresets.isEmpty()) {
            if (this.cardIndex < 0.0) {
                this.cardIndex = loadedPresets.indexOf(SkinPresetManager.getChosenPreset()) / this.getRows() * this.getRows();
            }
            this.lastCardIndex = this.cardIndex;
        } else {
            this.cardIndex = 0.0;
            this.lastCardIndex = 0.0;
        }
        for (SpruceWidget spruceWidget : this.carouselWidgets) {
            this.method_37063((class_364)spruceWidget);
        }
        this.cancelButton = (SpruceButtonWidget)this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(this.field_22789 / 2 - 128 - 5), (int)(this.field_22790 - 23)), 128, 20, class_5244.field_24335, button -> this.method_25419()));
        this.configButton = (SpruceIconButtonWidget)this.method_37063((class_364)new ActualSpruceIconButtonWidget(Position.of((int)2, (int)2), 20, 20, (class_2561)class_2561.method_43473(), btn -> this.field_22787.method_29970(GeneratedScreens.getConfigScreen((class_437)this)), btn -> SkinShuffle.id("textures/gui/config-button-icon.png")));
        this.configButton.setTooltip((class_2561)class_2561.method_43471((String)"skinshuffle.carousel.config_button.tooltip"));
        this.viewTypeButton = (SpruceIconButtonWidget)this.method_37063((class_364)new ActualSpruceIconButtonWidget(Position.of((int)24, (int)2), 20, 20, (class_2561)class_2561.method_43473(), btn -> {
            this.field_22787.method_29970((class_437)this.nextViewType.factory.apply(this.parent));
            SkinShuffleConfig.get().carouselView = this.nextViewType;
            SkinShuffleConfig.save();
        }, btn -> this.viewType.iconTexture));
        this.viewTypeButton.setTooltip(this.viewType.tooltip);
        this.selectButton = (SpruceButtonWidget)this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(this.field_22789 / 2 + 5), (int)(this.field_22790 - 23)), 128, 20, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.save_button"), button -> {
            if (Math.round(this.cardIndex) >= 0L && Math.round(this.cardIndex) < (long)this.carouselWidgets.size()) {
                SpruceWidget chosenPresetWidget = (SpruceWidget)this.carouselWidgets.get((int)Math.round(this.cardIndex));
                if (chosenPresetWidget instanceof AddCardWidget) {
                    this.method_25419();
                    return;
                }
                if (chosenPresetWidget instanceof PresetWidget) {
                    PresetWidget presetWidget = (PresetWidget)chosenPresetWidget;
                    SkinPresetManager.setChosenPreset(presetWidget.getPreset(), this.hasEditedPreset);
                    SkinPresetManager.savePresets();
                }
            }
            this.handleCloseBehaviour();
        }));
        this.refreshPresetState();
    }

    public void handleCloseBehaviour() {
        if (this.field_22787.field_1687 != null && !ClientSkinHandling.isInstalledOnServer()) {
            this.field_22787.method_1507(GeneratedScreens.getReconnectScreen(this.parent));
        } else {
            this.method_25419();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        for (SkinPreset preset : SkinPresetManager.getLoadedPresets()) {
            try {
                ConfigSkin configSkin = preset.getSkin().saveToConfig();
                preset.setSkin(configSkin);
            }
            catch (Exception exception) {}
        }
        SkinPresetManager.savePresets();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        int cardAreaWidth = this.getCardWidth() + this.getCardGap();
        this.method_25420(graphics);
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        graphics.method_25294(0, 9 * 3, this.field_22789, this.field_22790 - 9 * 3, 0x7F000000);
        Objects.requireNonNull(this.field_22793);
        int n = (int)(9.0 * 2.75);
        Objects.requireNonNull(this.field_22793);
        graphics.method_25296(0, n, this.field_22789, 9 * 3, 0, 0x7F000000);
        Objects.requireNonNull(this.field_22793);
        double d = this.field_22790;
        Objects.requireNonNull(this.field_22793);
        graphics.method_25296(0, this.field_22790 - 9 * 3, this.field_22789, (int)(d - 9.0 * 2.75), 0x7F000000, 0);
        ScissorManager.pushScaleFactor((double)this.scaleFactor);
        int rows = this.getRows();
        int fullHeight = this.getCardHeight() * rows + this.getCardGap() * (rows - 1);
        int top = this.field_22790 / 2 - fullHeight / 2;
        double deltaIndex = this.getDeltaScrollIndex() / (double)rows;
        int scrollOffset = (int)((-deltaIndex + 1.0) * (double)cardAreaWidth);
        Position scrollOffsetPosition = Position.of((int)scrollOffset, (int)0);
        int draggingIndex = -1;
        int hoveredIndex = -1;
        int i = 0;
        int leftI = this.field_22789 / 2 - cardAreaWidth - this.getCardWidth() / 2;
        int rowI = 0;
        for (AbstractCardWidget<?> widget : this.carouselWidgets) {
            int topI = top + (this.getCardHeight() + this.getCardGap()) * rowI;
            Position position = Position.of((SprucePositioned)scrollOffsetPosition, (int)widget.getDeltaX(leftI), (int)widget.getDeltaY(topI));
            if (this.supportsDragging()) {
                int boundLeft = leftI + scrollOffsetPosition.getX();
                int boundTop = topI + scrollOffsetPosition.getY();
                if (mouseX > boundLeft && mouseX < boundLeft + widget.getWidth() && mouseY > boundTop && mouseY < boundTop + widget.getHeight() && widget.isMovable()) {
                    hoveredIndex = i;
                }
                if (widget.isDragging() && widget.isMovable()) {
                    position = Position.of((int)(mouseX - (int)widget.getDragStartX()), (int)(mouseY - (int)widget.getDragStartY()));
                    draggingIndex = i;
                }
            }
            if (widget instanceof PresetWidget) {
                PresetWidget loadedPreset = (PresetWidget)widget;
                loadedPreset.overridePosition(position);
                loadedPreset.setScaleFactor(this.scaleFactor);
            } else if (widget instanceof AddCardWidget) {
                AddCardWidget addCardWidget = (AddCardWidget)widget;
                addCardWidget.overridePosition(position);
            }
            widget.setActive(Math.round(this.cardIndex) == (long)i || this.getRows() > 1);
            widget.updateVisibility(i);
            if (++rowI >= rows) {
                rowI = 0;
                leftI += cardAreaWidth;
            }
            ++i;
        }
        if (draggingIndex != -1 && hoveredIndex != -1 && draggingIndex != hoveredIndex) {
            this.swapPresets(draggingIndex, hoveredIndex);
            this.refreshPresetState();
        }
        this.renderWidgets(graphics, mouseX, mouseY, delta);
        this.renderTitle(graphics, mouseX, mouseY, delta);
        Tooltip.renderAll((class_332)graphics);
        ScissorManager.popScaleFactor();
    }

    public void renderTitle(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_5481 class_54812 = this.method_25440().method_30937();
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        graphics.method_35719(this.field_22793, class_54812, n, 9, -1);
    }

    public void scrollCarousel(double amount, boolean wrapAround) {
        if (this.carouselWidgets.size() == 1) {
            return;
        }
        double cardIndex = this.cardIndex + (amount *= (double)this.getRows());
        if (wrapAround) {
            cardIndex = (cardIndex + (double)this.carouselWidgets.size()) % (double)this.carouselWidgets.size();
        }
        cardIndex = class_3532.method_15350((double)cardIndex, (double)0.0, (double)((this.carouselWidgets.size() - 1) / this.getRows() * this.getRows()));
        this.setCardIndex(cardIndex);
    }

    public void snapCarousel() {
        long cardIndex = Math.round(this.cardIndex) / (long)this.getRows() * (long)this.getRows();
        this.setCardIndex(cardIndex);
    }

    public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        int sign = SkinShuffleConfig.get().invertCarouselScroll ? -1 : 1;
        this.scrollCarousel(-verticalAmount / 4.0 * (double)SkinShuffleConfig.get().carouselScrollSensitivity * (double)sign, false);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.carouselWidgets.forEach((Consumer<AbstractCardWidget<?>>)((Consumer<AbstractCardWidget>)widget -> widget.setDragging(false)));
        return super.method_25406(mouseX, mouseY, button);
    }

    protected abstract int getRows();

    public int getCardWidth() {
        return this.field_22789 / 4;
    }

    public int getCardHeight() {
        return ((int)((double)this.field_22790 / 1.5) - this.getCardGap() * (this.getRows() - 1)) / this.getRows();
    }

    public int getCardGap() {
        return (int)(10.0 * this.scaleFactor) / this.getRows();
    }

    protected boolean supportsDragging() {
        return false;
    }

    protected abstract AbstractCardWidget widgetFromPreset(SkinPreset var1);

    private double getDeltaScrollIndex() {
        double deltaTime = (class_3673.method_15974() - this.lastCardSwitchTime) * 5.0;
        deltaTime = class_3532.method_15350((double)deltaTime, (double)0.0, (double)1.0);
        deltaTime = Math.sin(deltaTime * Math.PI / 2.0);
        return class_3532.method_16436((double)deltaTime, (double)this.lastCardIndex, (double)this.cardIndex);
    }

    public AbstractCardWidget loadPreset(SkinPreset preset) {
        AbstractCardWidget widget = this.widgetFromPreset(preset);
        this.carouselWidgets.get(this.carouselWidgets.size() - 1).refreshLastPosition();
        this.carouselWidgets.add(this.carouselWidgets.set(this.carouselWidgets.size() - 1, widget));
        this.refreshPresetState();
        return widget;
    }

    public void swapPresets(int index1, int index2) {
        this.carouselWidgets.get(index1).refreshLastPosition();
        this.carouselWidgets.get(index2).refreshLastPosition();
        Collections.swap(this.carouselWidgets, index1, index2);
        SkinPresetManager.swapPresets(index1, index2);
        this.refreshPresetState();
    }

    public Optional<PresetWidget<?>> getPresetWidget(int index) {
        if (index < 0 || index >= this.carouselWidgets.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.carouselWidgets.get(index)).filter(widget -> widget instanceof PresetWidget).map(widget -> (PresetWidget)((Object)widget));
    }

    public void refreshPresetState() {
        this.carouselWidgets.forEach((Consumer<AbstractCardWidget<?>>)((Consumer<AbstractCardWidget>)AbstractCardWidget::refreshState));
    }

    public void setCardIndex(double index) {
        this.lastCardIndex = this.getDeltaScrollIndex();
        this.lastCardSwitchTime = class_3673.method_15974();
        this.cardIndex = index;
    }

    public double getLastCardSwitchTime() {
        return this.lastCardSwitchTime;
    }

    public void refresh() {
        this.method_25396().clear();
        this.method_25426();
    }
}

