/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.lockandblock.client.render;

import com.andersmmg.lockandblock.LockAndBlock;
import com.andersmmg.lockandblock.block.custom.LaserBlock;
import com.andersmmg.lockandblock.block.entity.LaserBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class LaserBlockEntityRenderer
implements class_827<LaserBlockEntity> {
    public static final class_2960 BEAM_TEXTURE = new class_2960("lockandblock", "textures/entity/laser.png");

    public LaserBlockEntityRenderer(class_5614.class_5615 ignoredContext) {
    }

    public static void renderBeam(class_4587 matrices, class_4597 vertexConsumers, class_2960 textureId, int yOffset, int maxY, float[] color, float radius, class_2350 direction, float alpha) {
        int i = yOffset + maxY;
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        switch (direction) {
            case field_11033: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                matrices.method_22904(0.0, -1.0, 0.0);
                break;
            }
            case field_11036: {
                break;
            }
            case field_11043: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                matrices.method_22904(0.0, -0.5, 0.5);
                break;
            }
            case field_11035: {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                matrices.method_22904(0.0, -0.5, -0.5);
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                matrices.method_22904(0.5, -0.5, 0.0);
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
                matrices.method_22904(-0.5, -0.5, 0.0);
            }
        }
        matrices.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        LaserBlockEntityRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(class_1921.method_23592((class_2960)textureId, (boolean)true)), color[0], color[1], color[2], alpha, yOffset, i, radius, radius, -radius, -radius);
        matrices.method_22909();
    }

    private static void renderBeamLayer(class_4587 matrices, class_4588 vertices, float red, float green, float blue, float alpha, int yOffset, int height, float z1, float x2, float x3, float z4) {
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        LaserBlockEntityRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, 0.0f, z1, x2, 0.0f);
        LaserBlockEntityRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, 0.0f, z4, x3, 0.0f);
        LaserBlockEntityRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x2, 0.0f, 0.0f, z4);
        LaserBlockEntityRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x3, 0.0f, 0.0f, z1);
    }

    private static void renderBeamFace(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 vertices, float red, float green, float blue, float alpha, int yOffset, int height, float x1, float z1, float x2, float z2) {
        LaserBlockEntityRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x1, z1, 1.0f, 1.0f);
        LaserBlockEntityRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x1, z1, 1.0f, -1.0f);
        LaserBlockEntityRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x2, z2, 0.0f, -1.0f);
        LaserBlockEntityRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x2, z2, 0.0f, 1.0f);
    }

    private static void renderBeamVertex(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 vertices, float red, float green, float blue, float alpha, int y, float x, float z, float u, float v) {
        vertices.method_22918(positionMatrix, x, (float)y, z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
    }

    public void render(LaserBlockEntity entity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
        if (!LockAndBlock.CONFIG.laserCustomRender()) {
            return;
        }
        if (entity.isActive(entity.method_11010())) {
            int totalDistance = LaserBlockEntity.getDistance(entity);
            if (totalDistance < LockAndBlock.CONFIG.maxLaserDistance()) {
                this.renderSection(entity, matrixStack, vertexConsumerProvider, 0, totalDistance, 1.0f);
                return;
            }
            int firstSectionDistance = totalDistance > 4 ? totalDistance - 4 : totalDistance;
            this.renderSection(entity, matrixStack, vertexConsumerProvider, 0, firstSectionDistance + 1, 1.0f);
            for (int i = 1; i < 4; ++i) {
                float alpha = (float)(totalDistance - i) / (float)totalDistance;
                this.renderSection(entity, matrixStack, vertexConsumerProvider, firstSectionDistance + i, 1, alpha *= (float)(4 - i) / 4.0f);
            }
        }
    }

    public void renderSection(LaserBlockEntity entity, class_4587 matrixStack, class_4597 vertexConsumerProvider, int yOffset, int maxY, float alpha) {
        float[] color = this.argbToFloat(LaserBlockEntity.getColor(entity.method_11010()));
        class_2350 direction = (class_2350)entity.method_11010().method_11654((class_2769)LaserBlock.FACING);
        double distance = 0.0;
        if (class_310.method_1551().field_1719 != null) {
            distance = this.getDistance(entity, class_310.method_1551().field_1719.method_19538());
        }
        double radius = (double)0.03f + (double)5.0E-4f * distance;
        LaserBlockEntityRenderer.renderBeam(matrixStack, vertexConsumerProvider, BEAM_TEXTURE, yOffset, maxY, color, (float)radius, direction, alpha);
    }

    private float[] argbToFloat(int color) {
        float[] floatColor = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return floatColor;
    }

    public boolean rendersOutsideBoundingBox(LaserBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return 128;
    }

    public boolean isInRenderDistance(LaserBlockEntity blockEntity, class_243 pos) {
        return class_243.method_24953((class_2382)blockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_24802((class_2374)pos.method_18805(1.0, 0.0, 1.0), (double)this.method_33893());
    }

    public double getDistance(LaserBlockEntity blockEntity, class_243 pos) {
        return class_243.method_24953((class_2382)blockEntity.method_11016()).method_18805(1.0, 0.0, 1.0).method_1022(pos.method_18805(1.0, 0.0, 1.0));
    }
}

