/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.lockandblock.block.entity;

import com.andersmmg.lockandblock.LockAndBlock;
import com.andersmmg.lockandblock.block.ModBlocks;
import com.andersmmg.lockandblock.block.custom.LaserBlock;
import com.andersmmg.lockandblock.block.custom.LaserSensorBlock;
import com.andersmmg.lockandblock.block.custom.RedstoneLaser;
import com.andersmmg.lockandblock.block.custom.TripMineBlock;
import com.andersmmg.lockandblock.block.entity.ModBlockEntities;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_5431;
import net.minecraft.class_7923;

public class LaserBlockEntity
extends class_2586 {
    public int currentDistance = 0;

    public LaserBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.LASER_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, LaserBlockEntity laserBlockEntity) {
        LaserBlockEntity.updateDistance(blockState, world, blockPos, laserBlockEntity);
        if (!world.field_9236) {
            return;
        }
        if (LockAndBlock.CONFIG.laserParticles()) {
            class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12525);
            for (int i = 1; i <= laserBlockEntity.currentDistance; ++i) {
                LaserBlockEntity.spawnParticles(blockState, world, blockPos.method_10079(direction, i));
            }
        }
    }

    public static void updateDistance(class_2680 state, class_1937 world, class_2338 pos, LaserBlockEntity laserBlockEntity) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)LaserSensorBlock.FACING);
        int newDistance = LockAndBlock.CONFIG.allowLaserInAir() ? LockAndBlock.CONFIG.maxLaserDistance() + 1 : 0;
        for (int i = 1; i <= LockAndBlock.CONFIG.maxLaserDistance() + 1; ++i) {
            class_2680 blockState = world.method_8320(pos.method_10079(direction, i));
            String blockId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
            if (LockAndBlock.CONFIG.laserPassthroughWhitelist().contains(blockId) || blockState.method_26202((class_1922)world, pos.method_10079(direction, i), class_3726.method_16194()).method_1110()) continue;
            if (blockState.method_30368((class_1922)world, pos.method_10079(direction, i), direction.method_10153(), class_5431.field_25823)) {
                newDistance = i;
                break;
            }
            if (!blockState.method_30368((class_1922)world, pos.method_10079(direction, i), direction, class_5431.field_25823)) continue;
            newDistance = i + 1;
            break;
        }
        laserBlockEntity.currentDistance = newDistance;
    }

    public static int getDistance(LaserBlockEntity entity) {
        return entity.currentDistance;
    }

    public static int getColor(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block.equals(ModBlocks.TRIP_MINE)) {
            return 65280;
        }
        if (block.equals(ModBlocks.LASER_SENSOR)) {
            return 3194623;
        }
        if (block.equals(ModBlocks.REDSTONE_LASER)) {
            return 0xFF0000;
        }
        return 0;
    }

    private static void spawnParticles(class_2680 state, class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            return;
        }
        int colorRgb = LaserBlockEntity.getColor(state);
        class_2350 direction = ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
        class_2350 direction2 = LaserBlock.getDirection(state).method_10153();
        double d = (double)pos.method_10263() + 0.5 + 0.0 * (double)direction.method_10148() + 0.4 * (double)direction2.method_10148();
        double e = (double)pos.method_10264() + 0.5 + 0.0 * (double)direction.method_10164() + 0.4 * (double)direction2.method_10164();
        double f = (double)pos.method_10260() + 0.5 + 0.0 * (double)direction.method_10165() + 0.4 * (double)direction2.method_10165();
        float steps = 10.0f;
        for (int i = 0; i < (int)steps; ++i) {
            world.method_8406((class_2394)new class_2390(class_243.method_24457((int)colorRgb).method_46409(), 0.5f), d + (double)direction.method_10148() * (double)((float)i / steps), e + (double)direction.method_10164() * (double)((float)i / steps), f + (double)direction.method_10165() * (double)((float)i / steps), 0.0, 0.0, 0.0);
        }
    }

    public boolean isActive(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block.equals(ModBlocks.TRIP_MINE)) {
            return (Boolean)state.method_11654((class_2769)TripMineBlock.SET);
        }
        if (block.equals(ModBlocks.LASER_SENSOR)) {
            return (Boolean)state.method_11654((class_2769)LaserSensorBlock.SET);
        }
        if (block.equals(ModBlocks.REDSTONE_LASER)) {
            return (Boolean)state.method_11654((class_2769)RedstoneLaser.POWERED);
        }
        return false;
    }
}

