/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.item.block.util.INoTab;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3620;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public class BlockDragonForgeCore
extends class_2237
implements IDragonProof,
INoTab {
    private final int isFire;
    private final boolean activated;

    public BlockDragonForgeCore(int isFire, boolean activated) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_9624().method_9629(40.0f, 500.0f).method_9626(class_2498.field_11533).method_9631(state -> activated ? 15 : 0));
        this.isFire = isFire;
        this.activated = activated;
    }

    public static String name(int dragonType, boolean activated) {
        return "dragonforge_%s_core%s".formatted(DragonType.getNameFromInt(dragonType), activated ? "" : "_disabled");
    }

    public static void setState(int dragonType, boolean active, class_1937 worldIn, class_2338 pos) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (active) {
            switch (dragonType) {
                case 0: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_FIRE_CORE.get()).method_9564(), 3);
                    break;
                }
                case 1: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_ICE_CORE.get()).method_9564(), 3);
                    break;
                }
                case 2: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get()).method_9564(), 3);
                }
            }
        } else {
            switch (dragonType) {
                case 0: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).method_9564(), 3);
                    break;
                }
                case 1: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).method_9564(), 3);
                    break;
                }
                case 2: {
                    worldIn.method_8652(pos, ((class_2248)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).method_9564(), 3);
                }
            }
        }
        if (blockEntity != null) {
            blockEntity.method_10996();
            worldIn.method_8438(blockEntity);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!player.method_5715()) {
            class_3908 screenHandlerFactory;
            if (!world.field_9236 && (screenHandlerFactory = this.method_17454(state, world, pos)) != null) {
                player.method_17355(screenHandlerFactory);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_1799 getItem(class_1937 world, class_2338 pos, class_2680 state) {
        return switch (this.isFire) {
            case 1 -> new class_1799((class_1935)((class_2248)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).method_8389());
            case 2 -> new class_1799((class_1935)((class_2248)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).method_8389());
            default -> new class_1799((class_1935)((class_2248)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).method_8389());
        };
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BlockEntityDragonForge) {
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((BlockEntityDragonForge)blockEntity));
            world.method_8455(pos, (class_2248)this);
            world.method_8544(pos);
        }
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public boolean shouldBeInTab() {
        return !this.activated;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> entityType) {
        return BlockDragonForgeCore.method_31618(entityType, (class_2591)((class_2591)IafBlockEntities.DRAGONFORGE_CORE.get()), BlockEntityDragonForge::tick);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockEntityDragonForge(pos, state, this.isFire);
    }
}

