/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.block.BlockCharedPath;
import com.iafenvoy.iceandfire.item.block.BlockFallingReturningState;
import com.iafenvoy.iceandfire.item.block.BlockReturningState;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2500;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;

public class IafDragonDestructionManager {
    public static void destroyAreaBreath(class_1937 level, class_2338 center, EntityDragonBase dragon) {
        float damageScale;
        int statusDuration;
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.method_10263(), center.method_10264(), center.method_10260())) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 5 + dragon.getDragonStage() * 5;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageFire.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 50 * dragon.getDragonStage();
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageIce.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 3;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageLightning.getValue()).floatValue();
        } else {
            return;
        }
        double damageRadius = 3.5;
        boolean canBreakBlocks = level.method_8450().method_8355(class_1928.field_19388);
        if (dragon.getDragonStage() <= 3) {
            class_2338.method_20437((class_2338)center.method_10069(-1, -1, -1), (class_2338)center.method_10069(1, 1, 1)).forEach(position -> {
                class_2586 patt0$temp = level.method_8321(position);
                if (patt0$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt0$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && DragonUtils.canGrief(dragon) && dragon.method_6051().method_43056()) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        } else {
            int radius = dragon.getDragonStage() == 4 ? 2 : 3;
            int x = radius + level.field_9229.method_43048(1);
            int y = radius + level.field_9229.method_43048(1);
            int z = radius + level.field_9229.method_43048(1);
            float f = (float)(x + y + z) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            class_2338.method_20437((class_2338)center.method_10069(-x, -y, -z), (class_2338)center.method_10069(x, y, z)).forEach(position -> {
                class_2586 patt0$temp = level.method_8321(position);
                if (patt0$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt0$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && center.method_10262((class_2382)position) <= (double)ff && DragonUtils.canGrief(dragon) && level.field_9229.method_43057() > (float)center.method_10262((class_2382)position) / ff) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        }
        class_1282 damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        float stageDamage = (float)dragon.getDragonStage() * damageScale;
        level.method_18467(class_1309.class, new class_238((double)center.method_10263() - damageRadius, (double)center.method_10264() - damageRadius, (double)center.method_10260() - damageRadius, (double)center.method_10263() + damageRadius, (double)center.method_10264() + damageRadius, (double)center.method_10260() + damageRadius)).forEach(target -> {
            if (!DragonUtils.onSameTeam((class_1297)dragon, (class_1297)target) && !dragon.method_5779((class_1297)target) && dragon.method_6057((class_1297)target)) {
                target.method_5643(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
    }

    public static void destroyAreaCharge(class_1937 level, class_2338 center, EntityDragonBase dragon) {
        int statusDuration;
        boolean canBreakBlocks;
        if (dragon == null) {
            return;
        }
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.method_10263(), center.method_10264(), center.method_10260())) {
            return;
        }
        int x = 2;
        int y = 2;
        int z = 2;
        boolean bl = canBreakBlocks = DragonUtils.canGrief(dragon) && level.method_8450().method_8355(class_1928.field_19388);
        if (canBreakBlocks) {
            if (dragon.getDragonStage() <= 3) {
                class_2338.method_20437((class_2338)center.method_10069(-x, -y, -z), (class_2338)center.method_10069(x, y, z)).forEach(position -> {
                    class_2680 state = level.method_8320(position);
                    if (state.method_26204() instanceof IDragonProof) {
                        return;
                    }
                    if ((double)(dragon.method_6051().method_43057() * 3.0f) > center.method_10262((class_2382)position) && DragonUtils.canDragonBreak(state, (class_1297)dragon)) {
                        level.method_22352(position, false);
                    }
                    if (dragon.method_6051().method_43056()) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position, state);
                    }
                });
            } else {
                int radius = dragon.getDragonStage() == 4 ? 2 : 3;
                x = radius + level.field_9229.method_43048(2);
                y = radius + level.field_9229.method_43048(2);
                z = radius + level.field_9229.method_43048(2);
                float f = (float)(x + y + z) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(level, center, x, y, z, ff, (class_1297)dragon);
                class_2338.method_20437((class_2338)center.method_10069(-(++x), -(++y), -(++z)), (class_2338)center.method_10069(x, y, z)).forEach(position -> {
                    if (center.method_10262((class_2382)position) <= (double)ff) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position);
                    }
                });
            }
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 15;
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 400;
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 9;
        } else {
            return;
        }
        float stageDamage = (float)Math.max(1, dragon.getDragonStage() - 1) * 2.0f;
        class_1282 damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        level.method_18467(class_1309.class, new class_238((double)center.method_10263() - (double)x, (double)center.method_10264() - (double)y, (double)center.method_10260() - (double)z, (double)center.method_10263() + (double)x, (double)center.method_10264() + (double)y, (double)center.method_10260() + (double)z)).forEach(target -> {
            if (!dragon.method_5722((class_1297)target) && !dragon.method_5779((class_1297)target) && dragon.method_6057((class_1297)target)) {
                target.method_5643(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.explosiveBreath.getValue()).booleanValue()) {
            IafDragonDestructionManager.causeExplosion(level, center, dragon, damageSource, dragon.getDragonStage());
        }
    }

    private static class_1282 getDamageSource(EntityDragonBase dragon) {
        class_1657 player = dragon.getRidingPlayer();
        if (dragon.dragonType == DragonType.FIRE) {
            return player != null ? IafDamageTypes.causeIndirectDragonFireDamage((class_1297)dragon, (class_1297)player) : IafDamageTypes.causeDragonFireDamage((class_1297)dragon);
        }
        if (dragon.dragonType == DragonType.ICE) {
            return player != null ? IafDamageTypes.causeIndirectDragonIceDamage((class_1297)dragon, (class_1297)player) : IafDamageTypes.causeDragonIceDamage((class_1297)dragon);
        }
        if (dragon.dragonType == DragonType.LIGHTNING) {
            return player != null ? IafDamageTypes.causeIndirectDragonLightningDamage((class_1297)dragon, (class_1297)player) : IafDamageTypes.causeDragonLightningDamage((class_1297)dragon);
        }
        return dragon.method_37908().method_48963().method_48812((class_1309)dragon);
    }

    private static void attackBlock(class_1937 level, EntityDragonBase dragon, class_2338 position, class_2680 state) {
        boolean doPlaceBlock;
        class_2248 elementalBlock;
        class_2680 transformed;
        if (state.method_26204() instanceof IDragonProof || !DragonUtils.canDragonBreak(state, (class_1297)dragon)) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            transformed = IafDragonDestructionManager.transformBlockFire(state);
        } else if (dragon.dragonType == DragonType.ICE) {
            transformed = IafDragonDestructionManager.transformBlockIce(state);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            transformed = IafDragonDestructionManager.transformBlockLightning(state);
        } else {
            return;
        }
        if (!transformed.method_27852(state.method_26204())) {
            level.method_8501(position, transformed);
        }
        if (dragon.dragonType == DragonType.FIRE) {
            elementalBlock = class_2246.field_10036;
            doPlaceBlock = dragon.method_6051().method_43056();
        } else if (dragon.dragonType == DragonType.ICE) {
            elementalBlock = (class_2248)IafBlocks.DRAGON_ICE_SPIKES.get();
            doPlaceBlock = dragon.method_6051().method_43048(9) == 0;
        } else {
            return;
        }
        class_2680 stateAbove = level.method_8320(position.method_10084());
        if (doPlaceBlock && transformed.method_51367() && stateAbove.method_26227().method_15769() && !stateAbove.method_26225() && state.method_26225() && DragonUtils.canDragonBreak(stateAbove, (class_1297)dragon)) {
            level.method_8501(position.method_10084(), elementalBlock.method_9564());
        }
    }

    private static void attackBlock(class_1937 level, EntityDragonBase dragon, class_2338 position) {
        IafDragonDestructionManager.attackBlock(level, dragon, position, level.method_8320(position));
    }

    private static void applyDragonEffect(class_1309 target, EntityDragonBase dragon, int statusDuration) {
        if (dragon.dragonType == DragonType.FIRE) {
            target.method_5639(statusDuration);
        } else if (dragon.dragonType == DragonType.ICE) {
            IafEntityData data = IafEntityData.get(target);
            data.frozenData.setFrozen(target, statusDuration);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            double x = dragon.method_23317() - target.method_23317();
            double y = dragon.method_23321() - target.method_23321();
            target.method_6005((double)statusDuration / 10.0, x, y);
        }
    }

    private static void causeExplosion(class_1937 world, class_2338 center, EntityDragonBase destroyer, class_1282 source, int stage) {
        class_1927.class_4179 mode = world.method_8450().method_8355(class_1928.field_19388) ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878;
        BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (class_1308)destroyer, source, center.method_10263(), center.method_10264(), center.method_10260(), Math.min(2, stage - 2), mode);
        explosion.method_8348();
        explosion.method_8350(true);
    }

    private static void destroyBlocks(class_1937 world, class_2338 center, int x, int y, int z, double radius2, class_1297 destroyer) {
        class_2338.method_20437((class_2338)center.method_10069(-x, -y, -z), (class_2338)center.method_10069(x, y, z)).forEach(pos -> {
            if (center.method_10262((class_2382)pos) <= radius2) {
                class_2680 state = world.method_8320(pos);
                if (state.method_26204() instanceof IDragonProof) {
                    return;
                }
                if ((double)(world.field_9229.method_43057() * 3.0f) > (double)((float)center.method_10262((class_2382)pos)) / radius2 && DragonUtils.canDragonBreak(state, destroyer)) {
                    world.method_22352(pos, false);
                }
            }
        });
    }

    public static class_2680 transformBlockFire(class_2680 in) {
        if (in.method_26204() instanceof class_2500) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_GRASS.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_27852(class_2246.field_10566)) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_DIRT.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15466) && in.method_26204() == class_2246.field_10255) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_GRAVEL.get()).method_9564().method_11657((class_2769)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_25806) && (in.method_26204() == class_2246.field_10445 || in.method_26204().method_9539().contains("cobblestone"))) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_COBBLESTONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_25806) && in.method_26204() != IafBlocks.CHARRED_COBBLESTONE.get()) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_STONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26204() == class_2246.field_10194) {
            return (class_2680)((class_2248)IafBlocks.CHARRED_DIRT_PATH.get()).method_9564().method_11657((class_2769)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15475) || in.method_26164(class_3481.field_15471)) {
            return ((class_2248)IafBlocks.ASH.get()).method_9564();
        }
        if (in.method_26164(class_3481.field_15503) || in.method_26164(class_3481.field_20339) || in.method_26164(class_3481.field_20341) || in.method_26204() == class_2246.field_10477) {
            return class_2246.field_10124.method_9564();
        }
        return in;
    }

    public static class_2680 transformBlockIce(class_2680 in) {
        if (in.method_26204() instanceof class_2500) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_GRASS.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_29822) && in.method_26204() == class_2246.field_10566 || in.method_26164(class_3481.field_29823)) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_DIRT.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15466) && in.method_26204() == class_2246.field_10255) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_GRAVEL.get()).method_9564().method_11657((class_2769)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15466) && in.method_26204() != class_2246.field_10255) {
            return in;
        }
        if (in.method_26164(class_3481.field_25806) && (in.method_26204() == class_2246.field_10445 || in.method_26204().method_9539().contains("cobblestone"))) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_COBBLESTONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_25806) && in.method_26204() != IafBlocks.FROZEN_COBBLESTONE.get()) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_STONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26204() == class_2246.field_10194) {
            return (class_2680)((class_2248)IafBlocks.FROZEN_DIRT_PATH.get()).method_9564().method_11657((class_2769)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15475) || in.method_26164(class_3481.field_15471)) {
            return ((class_2248)IafBlocks.FROZEN_SPLINTERS.get()).method_9564();
        }
        if (in.method_27852(class_2246.field_10382)) {
            return class_2246.field_10295.method_9564();
        }
        if (in.method_26164(class_3481.field_15503) || in.method_26164(class_3481.field_20339) || in.method_26164(class_3481.field_20341) || in.method_26204() == class_2246.field_10477) {
            return class_2246.field_10124.method_9564();
        }
        return in;
    }

    public static class_2680 transformBlockLightning(class_2680 in) {
        if (in.method_26204() instanceof class_2500) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_GRASS.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_29822) && in.method_26204() == class_2246.field_10566) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_DIRT.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15466) && in.method_26204() == class_2246.field_10255) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_GRAVEL.get()).method_9564().method_11657((class_2769)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_25806) && (in.method_26204() == class_2246.field_10445 || in.method_26204().method_9539().contains("cobblestone"))) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_COBBLESTONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_25806) && in.method_26204() != IafBlocks.CRACKLED_COBBLESTONE.get()) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_STONE.get()).method_9564().method_11657((class_2769)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26204() == class_2246.field_10194) {
            return (class_2680)((class_2248)IafBlocks.CRACKLED_DIRT_PATH.get()).method_9564().method_11657((class_2769)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.method_26164(class_3481.field_15475) || in.method_26164(class_3481.field_15471)) {
            return ((class_2248)IafBlocks.ASH.get()).method_9564();
        }
        if (in.method_26164(class_3481.field_15503) || in.method_26164(class_3481.field_20339) || in.method_26164(class_3481.field_20341) || in.method_26204() == class_2246.field_10477) {
            return class_2246.field_10124.method_9564();
        }
        return in;
    }
}

