/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.jetbrains.annotations.Nullable;

public class ChunkFileReader {
    private static final AtomicBoolean ZERO_CHUNK_POS_ERROR_LOGGED_REF = new AtomicBoolean(false);
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;
    private static boolean lightingSectionErrorLogged = false;
    private static final ConcurrentHashMap<String, Object> LOGGED_ERROR_MESSAGE_MAP = new ConcurrentHashMap();

    public static LevelChunk read(WorldGenLevel level, ChunkPos chunkPos, CompoundTag chunkData) {
        int chunkZ;
        CompoundTag tagLevel = chunkData;
        int chunkX = ChunkFileReader.tagGetInt(tagLevel, "xPos");
        ChunkPos actualPos = new ChunkPos(chunkX, chunkZ = ChunkFileReader.tagGetInt(tagLevel, "zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            if (chunkX == 0 && chunkZ == 0) {
                if (!ZERO_CHUNK_POS_ERROR_LOGGED_REF.getAndSet(true)) {
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualPos.toString() + "])", new Object[0]);
                return null;
            }
        }
        ChunkStatus.ChunkType chunkType = ChunkFileReader.readChunkType(tagLevel);
        BlendingData blendingData = ChunkFileReader.readBlendingData(tagLevel);
        if (chunkType == ChunkStatus.ChunkType.PROTOCHUNK && blendingData == null) {
            return null;
        }
        long inhabitedTime = ChunkFileReader.tagGetLong(tagLevel, "InhabitedTime");
        UpgradeData upgradeData = UpgradeData.f_63320_;
        boolean isLightOn = ChunkFileReader.tagGetBoolean(tagLevel, "isLightOn");
        LevelChunkTicks blockTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(BLOCK_TICKS_TAG_18, 10), string -> BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(FLUID_TICKS_TAG_18, 10), string -> BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkSection[] levelChunkSections = ChunkFileReader.readSections((LevelAccessor)level, chunkPos, tagLevel);
        LevelChunk chunk = new LevelChunk((Level)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.m_8094_(isLightOn);
        ChunkFileReader.readHeightmaps(chunk, chunkData);
        return chunk;
    }

    private static LevelChunkSection[] readSections(LevelAccessor level, ChunkPos chunkPos, CompoundTag chunkData) {
        Registry biomes = level.m_9598_().m_175515_(Registries.f_256952_);
        Codec biomeCodec = PalettedContainer.m_238371_((IdMap)biomes.m_206115_(), (Codec)biomes.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomes.m_246971_(Biomes.f_48202_));
        int sectionYIndex = level.m_151559_();
        LevelChunkSection[] chunkSections = new LevelChunkSection[sectionYIndex];
        ListTag tagSections = ChunkFileReader.tagGetListTag(chunkData, "Sections", 10);
        if (tagSections == null || tagSections.isEmpty()) {
            tagSections = ChunkFileReader.tagGetListTag(chunkData, "sections", 10);
        }
        if (tagSections != null) {
            for (int j = 0; j < tagSections.size(); ++j) {
                byte sectionYPos;
                int sectionId;
                CompoundTag tagSection = ChunkFileReader.tagGetCompoundTag(tagSections, j);
                if (tagSection == null || (sectionId = level.m_151566_((int)(sectionYPos = ChunkFileReader.tagGetByte(tagSection, "Y")))) < 0 || sectionId >= chunkSections.length) continue;
                boolean containsBlockStates = tagSection.m_128425_("block_states", 10);
                PalettedContainer blockStateContainer = containsBlockStates ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)ChunkFileReader.tagGetCompoundTag(tagSection, "block_states")).promotePartial(string -> ChunkFileReader.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(false, message -> ChunkFileReader.logParsingWarningOnce(message)) : new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                boolean containsBiomes = tagSection.m_128425_("biomes", 10);
                PalettedContainer biomeContainer = containsBiomes ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)ChunkFileReader.tagGetCompoundTag(tagSection, "biomes")).promotePartial(string -> ChunkFileReader.logBiomeDeserializationWarning(chunkPos, sectionYIndex, string)).getOrThrow(false, message -> ChunkFileReader.logParsingWarningOnce(message)) : new PalettedContainer(biomes.m_206115_(), (Object)biomes.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                chunkSections[sectionId] = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
            }
        }
        return chunkSections;
    }

    private static ChunkStatus.ChunkType readChunkType(CompoundTag tagLevel) {
        ChunkStatus chunkStatus;
        String statusString = ChunkFileReader.tagGetString(tagLevel, "Status");
        if (statusString != null && (chunkStatus = ChunkStatus.m_62397_((String)statusString)) != null) {
            return chunkStatus.m_62494_();
        }
        return ChunkStatus.ChunkType.PROTOCHUNK;
    }

    private static void readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = ChunkFileReader.tagGetCompoundTag(chunkData, "Heightmaps");
        if (tagHeightmaps != null) {
            for (Heightmap.Types type : ChunkStatus.f_62326_.m_62500_()) {
                String heightmap = type.m_64294_();
                if (!tagHeightmaps.m_128425_(heightmap, 12)) continue;
                chunk.m_6511_(type, tagHeightmaps.m_128467_(heightmap));
            }
            Heightmap.m_64256_((ChunkAccess)chunk, (Set)ChunkStatus.f_62326_.m_62500_());
        }
    }

    private static BlendingData readBlendingData(CompoundTag chunkData) {
        BlendingData blendingData = null;
        boolean containsBlendingData = chunkData.m_128425_("blending_data", 10);
        if (containsBlendingData) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)chunkData.m_128469_("blending_data"));
            try {
                blendingData = BlendingData.f_190254_.parse(blendingDataTag).resultOrPartial(message -> ChunkFileReader.logParsingWarningOnce(message)).orElse(null);
            }
            catch (Exception e) {
                String message2 = e.getMessage();
                if (message2 == null || message2.trim().isEmpty()) {
                    message2 = "Failed to parse blending data";
                }
                ChunkFileReader.logParsingWarningOnce(message2, e);
            }
        }
        return blendingData;
    }

    public static CombinedChunkLightStorage readLight(ChunkAccess chunk, CompoundTag chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        Tag chunkSectionTags = chunkData.m_128423_("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.m_7697_()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof ListTag)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + ListTag.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        ListTag chunkSectionListTag = (ListTag)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            Tag chunkSectionTag = chunkSectionListTag.get(sectionIndex);
            if (!(chunkSectionTag instanceof CompoundTag)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + CompoundTag.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            CompoundTag chunkSectionCompoundTag = (CompoundTag)chunkSectionTag;
            byte[] blockLightNibbleArray = ChunkFileReader.tagGetByteArray(chunkSectionCompoundTag, "BlockLight");
            byte[] skyLightNibbleArray = ChunkFileReader.tagGetByteArray(chunkSectionCompoundTag, "SkyLight");
            if (blockLightNibbleArray == null || skyLightNibbleArray == null) continue;
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkFileReader.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkFileReader.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.f_45578_ + ", " + sectionYIndex + ", " + chunkPos.f_45579_ + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logBiomeDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.f_45578_ + ", " + sectionYIndex + ", " + chunkPos.f_45579_ + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logParsingWarningOnce(String message) {
        ChunkFileReader.logParsingWarningOnce(message, null);
    }

    private static void logParsingWarningOnce(String message, Exception e) {
        if (message == null) {
            return;
        }
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", e);
            return newMessage;
        });
    }

    private static RuntimeException logErrorAndReturnException(String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
        return null;
    }

    private static boolean tagGetBoolean(CompoundTag tag, String key) {
        return tag.m_128471_(key);
    }

    private static byte tagGetByte(CompoundTag tag, String key) {
        return tag.m_128445_(key);
    }

    private static short tagGetShort(ListTag tag, int index) {
        return tag.m_128757_(index);
    }

    private static int tagGetInt(CompoundTag tag, String key) {
        return tag.m_128451_(key);
    }

    private static long tagGetLong(CompoundTag tag, String key) {
        return tag.m_128451_(key);
    }

    @Nullable
    private static String tagGetString(CompoundTag tag, String key) {
        return tag.m_128461_(key);
    }

    @Nullable
    private static byte[] tagGetByteArray(CompoundTag tag, String key) {
        return tag.m_128463_(key);
    }

    @Nullable
    private static CompoundTag tagGetCompoundTag(CompoundTag tag, String key) {
        return tag.m_128469_(key);
    }

    @Nullable
    private static CompoundTag tagGetCompoundTag(ListTag tag, int index) {
        return tag.m_128728_(index);
    }

    @Nullable
    private static ListTag tagGetListTag(CompoundTag tag, String key, int elementType) {
        return tag.m_128437_(key, elementType);
    }

    @Nullable
    private static ListTag tagGetListTag(ListTag tag, int index) {
        return tag.m_128744_(index);
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

